unit Plecaki;
  { Ten modul zawiera opisy procedur, ktore moga byc wykorzystane
    do rozwiazywania ogolnego i decyzyjnego problemu plecakowego,
    opisanych w p. 11.2.}
interface
 {R+}
 const Maxn=50;
       MaxW=50;
 type Tablica1n  =array[1..Maxn] of integer;
      Tablica1nr =array[1..Maxn] of real;
      Tablica0n0W=array[0..Maxn,0..MaxW] of integer;

procedure ZachlannyPlecakOG(n:integer; p,w:Tablica1n; Waga:integer;
                            var q:Tablica1n; var Plecak:integer);
  {Zachlanne rozwiazanie ogolnego problemu plecakowego - dla
   pojemnosci plecaka Waga jego wartosc wynosi Plecak, p. 11.2.1.
   Rzeczy powinny byc uporzadkowane zgodnie z nierownosciami (11.4).}

 procedure ProgDynamPlecakOG(n:integer; p,w:Tablica1n; Waga:integer;
                             var PP,QQ:Tablica0n0W);
   {Rozwiazanie ogolnego problemu plecakowego metoda programowania
    dynamicznego, p. 11.2.2. Dla maksymalnej pojemnosci plecaka
    Waga, rozwiazania sa zapisane w tablicach PP,QQ[0..n,0..Waga].}

 function PlecakOG(n:integer; p,w:Tablica1n; m,Pojem:integer;
                   PP,QQ:Tablica0n0W; var q:Tablica1n):integer;
   {Odczytanie rozwiazania ogolnego problemu plecakowego dla
    m rzeczy i pojemnosci plecaka Pojem, p. 11.2.2. Wartoscia
    funkcji jest wartosc plecaka, a ilosci poszczegolnych rzeczy
    sa zapisane w tablicy q[1..m].}

 procedure ZachlannyPlecak01(n:integer; p,w:Tablica1n; Waga:integer;
                             var q:Tablica1n; var Plecak:integer);
   {Zachlanne rozwiazanie decyzyjnego problemu plecakowego - dla
    pojemnosci plecaka Waga jego wartosc wynosi Plecak, p. 11.2.3.
    Rzeczy powinny byc uporzadkowane zgodnie z nierownosciami (11.4).}

 procedure ProgDynamPlecak01(n:integer; p,w:Tablica1n; Waga:integer;
                             var PP,QQ:Tablica0n0W);
   {Rozwiazanie decyzyjnego problemu plecakowego metoda programowania
    dynamicznego, p. 11.2.4. Dla maksymalnej pojemnosci plecaka
    Waga, rozwiazania sa zapisane w tablicach PP,QQ[0..n,0..Waga].}

 function Plecak01(n:integer; p,w:Tablica1n; m,Pojem:integer;
                   PP,QQ:Tablica0n0W; var q:Tablica1n):integer;
   {Odczytanie rozwiazania decyzyjnego problemu plecakowego dla
    m rzeczy i pojemnosci plecaka Pojem, p. 11.2.4. Wartoscia
    funkcji jest wartosc plecaka, a ilosci poszczegolnych rzeczy
    sa zapisane w tablicy q[1..m].}

implementation

 procedure ZachlannyPlecakOG(n:integer; p,w:Tablica1n; Waga:integer;
                             var q:Tablica1n; var Plecak:integer);
   {Zachlanne rozwiazanie ogolnego problemu plecakowego - dla
    pojemnosci plecaka Waga jego wartosc wynosi Plecak, p. 11.2.1.
    Rzeczy powinny byc uporzadkowane zgodnie z nierownosciami (11.4).}
  var i:integer;
 begin
  Plecak:=0;
  for i:=1 to n do begin
   q[i]:=Waga div w[i];
   Waga:=Waga-q[i]*w[i];
   Plecak:=Plecak+p[i]*q[i]
  end
 end; {ZachlannyPlecakOG}

 procedure ProgDynamPlecakOG(n:integer; p,w:Tablica1n; Waga:integer;
                             var PP,QQ:Tablica0n0W);
   {Rozwiazanie ogolnego problemu plecakowego metoda programowania
    dynamicznego, p. 11.2.2. Dla maksymalnej pojemnosci plecaka
    Waga, rozwiazania sa zapisane w tablicach PP,QQ[0..n,0..Waga].}
  var i,j:integer;
 begin
  for i:=1 to n do begin
   PP[i,0]:=0;  QQ[i,0]:=0
  end;
  for j:=1 to Waga do begin
   PP[0,j]:=0;  QQ[0,j]:=0
  end;
  for i:=1 to n do
   for j:=1 to Waga do
    if (j>=w[i]) and (PP[i-1,j]<PP[i,j-w[i]]+p[i]) then begin
      PP[i,j]:=PP[i,j-w[i]]+p[i];
      QQ[i,j]:=i
    end
    else begin
     PP[i,j]:=PP[i-1,j];
     QQ[i,j]:=QQ[i-1,j]
    end
 end; {ProgDynamPlecakOG}

 function PlecakOG(n:integer; p,w:Tablica1n; m,Pojem:integer;
                   PP,QQ:Tablica0n0W; var q:Tablica1n):integer;
   {Odczytanie rozwiazania ogolnego problemu plecakowego dla
    m rzeczy i pojemnosci plecaka Pojem, p. 11.2.2. Wartoscia
    funkcji jest wartosc plecaka, a ilosci poszczegolnych rzeczy
    sa zapisane w tablicy q[1..m].}
  var i:integer;
 begin
  PlecakOG:=PP[m,Pojem];
  for i:=1 to m do q[i]:=0;
  while QQ[m,Pojem]>0 do begin
   q[QQ[m,Pojem]]:=q[QQ[m,Pojem]]+1;
   Pojem:=Pojem-w[QQ[m,Pojem]]
  end
 end; {PlecakOG}

 procedure ZachlannyPlecak01(n:integer; p,w:Tablica1n; Waga:integer;
                             var q:Tablica1n; var Plecak:integer);
   {Zachlanne rozwiazanie decyzyjnego problemu plecakowego - dla
    pojemnosci plecaka Waga jego wartosc wynosi Plecak, p. 11.2.3.
    Rzeczy powinny byc uporzadkowane zgodnie z nierownosciami (11.4).}
  var i:integer;
 begin
  Plecak:=0;
  for i:=1 to n do
   if Waga>=w[i] then begin
    q[i]:=1;
    Waga:=Waga-w[i];
    Plecak:=Plecak+p[i]
   end
   else q[i]:=0
 end; {ZachlannyPlecak01}

 procedure ProgDynamPlecak01(n:integer; p,w:Tablica1n; Waga:integer;
                             var PP,QQ:Tablica0n0W);
   {Rozwiazanie decyzyjnego problemu plecakowego metoda programowania
    dynamicznego, p. 11.2.4. Dla maksymalnej pojemnosci plecaka
    Waga, rozwiazania sa zapisane w tablicach PP,QQ[0..n,0..Waga].}
  var i,j:integer;
 begin
  for i:=1 to n do begin
   PP[i,0]:=0;  QQ[i,0]:=0
  end;
  for j:=1 to Waga do begin
   PP[0,j]:=0;  QQ[0,j]:=0
  end;
  for i:=1 to n do
   for j:=1 to Waga do
    if (j>=w[i]) and (PP[i-1,j]<PP[i-1,j-w[i]]+p[i]) then begin
      PP[i,j]:=PP[i-1,j-w[i]]+p[i];
      QQ[i,j]:=1
    end
    else begin
     PP[i,j]:=PP[i-1,j];
     QQ[i,j]:=0
    end
 end; {ProgDynamPlecak01}

 function Plecak01(n:integer; p,w:Tablica1n; m,Pojem:integer;
                   PP,QQ:Tablica0n0W; var q:Tablica1n):integer;
   {Odczytanie rozwiazania decyzyjnego problemu plecakowego dla
    m rzeczy i pojemnosci plecaka Pojem, p. 11.2.4. Wartoscia
    funkcji jest wartosc plecaka, a ilosci poszczegolnych rzeczy
    sa zapisane w tablicy q[1..m].}
  var i:integer;
 begin
  Plecak01:=PP[m,Pojem];
  for i:=1 to m do q[i]:=0;
  i:=m;
  while i>0 do begin
   q[i]:=QQ[i,Pojem];
   Pojem:=Pojem-w[i]*q[i];
   i:=i-1
  end
 end; {Plecak01}

end. {unit Plecaki}