# ****************************************************************************
# *                                                                          *
# *  directls.mak                                                            *
# *  ============                                                            * 
# *                                                                          *
# ****************************************************************************

# ****************************************************************************
# *                                                                          *
# *  Nazwa pliku makefile.                                                   *
# *                                                                          *
# ****************************************************************************

MAKNAM = directls.mak

# ****************************************************************************
# *                                                                          *
# *  Katalogi, w ktrych naley szuka plikw bibliotek.                     *
# *                                                                          *
# ****************************************************************************

LIBDRS =

# ****************************************************************************
# *                                                                          *
# *  Katalogi, w ktrych naley szuka plikw wczanych.                    *
# *                                                                          *
# ****************************************************************************

INCDRS = -I$(ALGOWC_TOPDIR)/include

# ****************************************************************************
# *                                                                          *
# *  Pliki bibliotek.                                                        *
# *                                                                          *
# ****************************************************************************

LIBFLS = -lm

# ****************************************************************************
# *                                                                          *
# *  Pliki rdowe.                                                         *
# *                                                                          *
# ****************************************************************************

SRCFLS = ex-2.c\
         $(ALGOWC_TOPDIR)/source/directls.c\
         $(ALGOWC_TOPDIR)/source/issort.c\
         $(ALGOWC_TOPDIR)/source/qksort.c
         
# ****************************************************************************
# *                                                                          *
# *  Pliki z kodem porednim.                                                *
# *                                                                          *
# ****************************************************************************

OBJFLS = ex-2.o\
         $(ALGOWC_TOPDIR)/source/directls.o\
         $(ALGOWC_TOPDIR)/source/issort.o\
         $(ALGOWC_TOPDIR)/source/qksort.o

# ****************************************************************************
# *                                                                          *
# *  Plik wykonywalny.                                                       *
# *                                                                          *
# ****************************************************************************

EXE    = ex-2.exe

# ****************************************************************************
# *                                                                          *
# *  Opcje kompilacji i konsolidacji.                                        *
# *                                                                          *
# ****************************************************************************

CC     = c89
LL     = c89
CFLAGS = -D_HPUX_SOURCE
LFLAGS =

# ****************************************************************************
# *                                                                          *
# *  Reguy.                                                                 *
# *                                                                          *
# ****************************************************************************

$(EXE): $(OBJFLS)
	$(LL) $(LFLAGS) -o $@ $(OBJFLS) $(LIBDRS) $(LIBFLS)

.c.o:
	$(CC) $(CFLAGS) -o $@ -c $(INCDRS) $<

all:
	make -f $(MAKNAM) clean
	make -f $(MAKNAM) depend

depend:
	makedepend $(INCDRS) -f $(MAKNAM) $(SRCFLS)
	make -f $(MAKNAM) $(EXE)

clean:
	-rm $(EXE)
	-rm $(OBJFLS)

# NIE USUWA TEGO WIERSZA -- zapewnia istnienie odpowiednich zalenoci.
