/*****************************************************************************
*                                                                            *
*  --------------------------------- bit.c --------------------------------  *
*                                                                            *
*****************************************************************************/

#include <string.h>

#include "bit.h"

/*****************************************************************************
*                                                                            *
*  -------------------------------- bit_get -------------------------------  *
*                                                                            *
*****************************************************************************/

int bit_get(const unsigned char *bits, int pos) {

unsigned char      mask;

int                i;

/*****************************************************************************
*                                                                            *
*  Ustawiamy mask na pobierany bit.                                         *
*                                                                            *
*****************************************************************************/

mask = 0x80;

for (i = 0; i < (pos % 8); i++)
   mask = mask >> 1;

/*****************************************************************************
*                                                                            *
*  Pobieramy bit.                                                            *
*                                                                            *
*****************************************************************************/

return (((mask & bits[(int)(pos / 8)]) == mask) ? 1 : 0);

}

/*****************************************************************************
*                                                                            *
*  -------------------------------- bit_set -------------------------------  *
*                                                                            *
*****************************************************************************/

void bit_set(unsigned char *bits, int pos, int state) {

unsigned char      mask;

int                i;

/*****************************************************************************
*                                                                            *
*  Ustawiamy mask na ustawiany bit.                                         *
*                                                                            *
*****************************************************************************/

mask = 0x80;

for (i = 0; i < (pos % 8); i++)
   mask = mask >> 1;

/*****************************************************************************
*                                                                            *
*  Ustawiamy bit.                                                            *
*                                                                            *
*****************************************************************************/

if (state)
   bits[pos / 8] = bits[pos / 8] | mask;
else
   bits[pos / 8] = bits[pos / 8] & (~mask);

return;

}

/*****************************************************************************
*                                                                            *
*  -------------------------------- bit_xor -------------------------------  *
*                                                                            *
*****************************************************************************/

void bit_xor(const unsigned char *bits1, const unsigned char *bits2, unsigned
   char *bitsx, int size) {

int                i;

/*****************************************************************************
*                                                                            *
*  Wyliczamy bitowe XOR (LUB wyczajce) dwch buforw.                     *
*                                                                            *
*****************************************************************************/

for (i = 0; i < size; i++) {

   if (bit_get(bits1, i) != bit_get(bits2, i))
      bit_set(bitsx, i, 1);
   else
      bit_set(bitsx, i, 0);

}

return;

}

/*****************************************************************************
*                                                                            *
*  ----------------------------- bit_rot_left -----------------------------  *
*                                                                            *
*****************************************************************************/

void bit_rot_left(unsigned char *bits, int size, int count) {

int                fbit,
                   lbit,
                   i,
                   j;

/*****************************************************************************
*                                                                            *
*  Przesuwamy bufor w lewo o wskazan liczb bitw.                          *
*                                                                            *
*****************************************************************************/

if (size > 0) {

   for (j = 0; j < count; j++) {

      for (i = 0; i <= ((size - 1) / 8); i++) {


         /********************************************************************
         *                                                                   *
         *  Pobieramy bit wysuwany poza biecy bajt.                        *
         *                                                                   *
         ********************************************************************/

         lbit = bit_get(&bits[i], 0);

         if (i == 0) {

            /*****************************************************************
            *                                                                *
            *  Zapamitujemy bit z pierrwszego bajtu.                        *
            *                                                                *
            *****************************************************************/

            fbit = lbit;

            }

         else {

            /*****************************************************************
            *                                                                *
            *  Ustawiamy prawy bit poprzedniego bajta na warto lewego bita *
            *  wysuwanego poza biecy bajt.                                 *
            *                                                                *
            *****************************************************************/

            bit_set(&bits[i - 1], 7, lbit);

         }

         /********************************************************************
         *                                                                   *
         *  Przesuwamy biecy bajt w lewo.                                  *
         *                                                                   *
         ********************************************************************/

         bits[i] = bits[i] << 1;

      }

      /***********************************************************************
      *                                                                      *
      *  Ustawiamy prawy bit bufora na warto bita przesunitego poza       *
      *  pierwszy bajt.                                                      *
      *                                                                      *
      ***********************************************************************/

      bit_set(bits, size - 1, fbit);

   }

}

return;

}
