/*****************************************************************************
*                                                                            *
*  ex-2.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Opis: Ilustracja sortowania zawartoci katalogu (rozdzai 12.)            *
*                                                                            *
*****************************************************************************/

#include <stdio.h>
#include <sys/param.h>
#include <unistd.h>

#include "directls.h"

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

Directory          *dir;

char               buffer[MAXPATHLEN];

int                count,
                   i;

/*****************************************************************************
*                                                                            *
*  Pobranie zawartoci katalogu.                                             *
*                                                                            *
*****************************************************************************/

if (argc > 1) {

   if ((count = directls(argv[1], &dir)) < 0) {

      fprintf(stdout, "Niemoliwy odczyt katalogu\n");
      exit(1);

   }

   }

else {
   
   if ((count = directls(getcwd(buffer, MAXPATHLEN), &dir)) < 0) {

      fprintf(stdout, "Odczyt katalogu niemoliwy\n");
      exit(1);

   }

}

/*****************************************************************************
*                                                                            *
*  Pokazanie zawartoci katalogu.                                            *
*                                                                            *
*****************************************************************************/

for (i = 0; i < count; i++)
   fprintf(stdout, "%s\n", dir[i].name);

fprintf(stdout, "%d znaleziono.\n", count);
free(dir);

return 0;

}
