/*****************************************************************************
*                                                                            *
*  ------------------------------- chtbl.c --------------------------------  *
*                                                                            *
*****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "list.h"
#include "chtbl.h"

/*****************************************************************************
*                                                                            *
*  ------------------------------ chtbl_init ------------------------------  *
*                                                                            *
*****************************************************************************/

int chtbl_init(CHTbl *htbl, int buckets, int (*h)(const void *key), int
   (*match)(const void *key1, const void *key2), void (*destroy)(void*data)) {

int                i;

/*****************************************************************************
*                                                                            *
*  Alokacja pamicie na tablic asocjacyjn.                                 *
*                                                                            *
*****************************************************************************/

if ((htbl->table = (List *)malloc(buckets * sizeof(List))) == NULL)
   return -1;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja pakietw.                                                   *
*                                                                            *
*****************************************************************************/

htbl->buckets = buckets;

for (i = 0; i < htbl->buckets; i++)
   list_init(&htbl->table[i], destroy);

/*****************************************************************************
*                                                                            *
*  Enkapsulacja funkcji.                                                     *
*                                                                            *
*****************************************************************************/

htbl->h = h;
htbl->match = match;
htbl->destroy = destroy;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja liczby elementw w tablicy.                                 *
*                                                                            *
*****************************************************************************/

htbl->size = 0;

return 0;

}

/*****************************************************************************
*                                                                            *
*  ---------------------------- chtbl_destroy -----------------------------  *
*                                                                            *
*****************************************************************************/

void chtbl_destroy(CHTbl *htbl) {

int                i;
 
/*****************************************************************************
*                                                                            *
*  Usuwanie kolejnych pakietw.                                              *
*                                                                            *
*****************************************************************************/

for (i = 0; i < htbl->buckets; i++) {

   list_destroy(&htbl->table[i]);

}

/*****************************************************************************
*                                                                            *
*  Zwalniania pamici zarezerwowanej na tablic asocjacyjn.                 *
*                                                                            *
*****************************************************************************/

free(htbl->table);

/*****************************************************************************
*                                                                            *
*  Niedozwolone ju adne operacja, na wszelki wypadek czycimy struktur.   *
*                                                                            *
*****************************************************************************/

memset(htbl, 0, sizeof(CHTbl));

return;

}

/*****************************************************************************
*                                                                            *
*  ----------------------------- chtbl_insert -----------------------------  *
*                                                                            *
*****************************************************************************/

int chtbl_insert(CHTbl *htbl, const void *data) {

void               *temp;

int                bucket,
                   retval;
 
/*****************************************************************************
*                                                                            *
*  Jeli dane s ju w tabeli, nie robimy nic.                               *
*                                                                            *
*****************************************************************************/

temp = (void *)data;

if (chtbl_lookup(htbl, &temp) == 0)
   return 1;

/*****************************************************************************
*                                                                            *
*  Mieszanie klucza.                                                         *
*                                                                            *
*****************************************************************************/

bucket = htbl->h(data) % htbl->buckets;

/*****************************************************************************
*                                                                            *
*  Wstawiania danych do pakietu.                                             *
*                                                                            *
*****************************************************************************/

if ((retval = list_ins_next(&htbl->table[bucket], NULL, data)) == 0)
   htbl->size++;

return retval;

}

/*****************************************************************************
*                                                                            *
*  ----------------------------- chtbl_remove -----------------------------  *
*                                                                            *
*****************************************************************************/

int chtbl_remove(CHTbl *htbl, void **data) {

ListElmt           *element,
                   *prev;

int                bucket;
 
/*****************************************************************************
*                                                                            *
*  Mieszanie klucza.                                                         *
*                                                                            *
*****************************************************************************/

bucket = htbl->h(*data) % htbl->buckets;

/*****************************************************************************
*                                                                            *
*  Wyszukiwanie danych w pakiecie.                                           *
*                                                                            *
*****************************************************************************/

prev = NULL;

for (element = list_head(&htbl->table[bucket]); element != NULL; element =
   list_next(element)) {

   if (htbl->match(*data, list_data(element))) {

      /***********************************************************************
      *                                                                      *
      *  Usuwanie danych z pakietu.                                          *
      *                                                                      *
      ***********************************************************************/

      if (list_rem_next(&htbl->table[bucket], prev, data) == 0) {

         htbl->size--;
         return 0;

         }

      else {

         return -1;

      }

   }

   prev = element;

}

/*****************************************************************************
*                                                                            *
*  Zwracamy informacj, e danych nie znaleziono.                            *
*                                                                            *
*****************************************************************************/

return -1;

}

/*****************************************************************************
*                                                                            *
*  ----------------------------- chtbl_lookup -----------------------------  *
*                                                                            *
*****************************************************************************/

int chtbl_lookup(const CHTbl *htbl, void **data) {

ListElmt           *element;

int                bucket;
 
/*****************************************************************************
*                                                                            *
*  Mieszanie klucza.                                                         *
*                                                                            *
*****************************************************************************/

bucket = htbl->h(*data) % htbl->buckets;

/*****************************************************************************
*                                                                            *
*  Wyszukiwanie danych w pakiecie.                                           *
*                                                                            *
*****************************************************************************/

for (element = list_head(&htbl->table[bucket]); element != NULL; element =
   list_next(element)) {

   if (htbl->match(*data, list_data(element))) {

      /***********************************************************************
      *                                                                      *
      *  Zwrot danych z tablicy.                                             *
      *                                                                      *
      ***********************************************************************/

      *data = list_data(element);
      return 0;

   }

}

/*****************************************************************************
*                                                                            *
*  Zwracamy informacj, e danych nie znaleziono.                            *
*                                                                            *
*****************************************************************************/

return -1;

}
