/*****************************************************************************
*                                                                            *
*  ------------------------------- encrypt.h ------------------------------  *
*                                                                            *
*****************************************************************************/

#ifndef ENCRYPT_H
#define ENCRYPT_H

/*****************************************************************************
*                                                                            *
*  Aby implementacja bya naprawd bezpieczna, Huge powinna mie             *
*  przynajmniej zamiast uytych poniej 10 (ULONG_MAX = 4294967295).         *
*                                                                            *
*****************************************************************************/

typedef unsigned long Huge;

/*****************************************************************************
*                                                                            *
*  Struktura na klucze publiczne RSA.                                        *
*                                                                            *
*****************************************************************************/

typedef struct RsaPubKey_ {

Huge               e;
Huge               n;

} RsaPubKey;

/*****************************************************************************
*                                                                            *
*  Struktura na klucze prywatne RSA.                                         *
*                                                                            *
*****************************************************************************/

typedef struct RsaPriKey_ {

Huge               d;
Huge               n;

} RsaPriKey;

/*****************************************************************************
*                                                                            *
*  --------------------------- Interfejs publiczny ------------------------  *
*                                                                            *
*****************************************************************************/

void des_encipher(const unsigned char *plaintext, unsigned char *ciphertext,
   const unsigned char *key);

void des_decipher(const unsigned char *ciphertext, unsigned char *plaintext,
   const unsigned char *key);

void rsa_encipher(Huge plaintext, Huge *ciphertext, RsaPubKey pubkey);

void rsa_decipher(Huge ciphertext, Huge *plaintext, RsaPriKey prikey);

#endif
