/*****************************************************************************
*                                                                            *
*  ex-1.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Opis: Ilustracja uycia kolejki (rozdzia 6.)                             *
*                                                                            *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "list.h"
#include "queue.h"

/*****************************************************************************
*                                                                            *
*  ------------------------------ print_queue -----------------------------  *
*                                                                            *
*****************************************************************************/

static void print_queue(const Queue *queue) {

ListElmt           *element;

int                *data,
                   size,
                   i;

/*****************************************************************************
*                                                                            *
*  Wywietlenie kolejki.                                                     *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Rozmiar kolejki to %d\n", size = queue_size(queue));

i = 0;
element = list_head(queue);

while (i < size) {

   data = list_data(element);
   fprintf(stdout, "queue[%03d]=%03d\n", i, *data);
   element = list_next(element);
   i++;

}

return;

}

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

Queue              queue;

int                *data,
                   i;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja kolejki.                                                    *
*                                                                            *
*****************************************************************************/

queue_init(&queue, free);

/*****************************************************************************
*                                                                            *
*  Operacje na kolejce.                                                      *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Wstawienie 10 elementw\n");

for (i = 0; i < 10; i++) {

   if ((data = (int *)malloc(sizeof(int))) == NULL)
      return 1;

   *data = i + 1;

   if (queue_enqueue(&queue, data) != 0)
      return 1;

}

print_queue(&queue);

fprintf(stdout, "Usunicie z kolejki 5 elementw.\n");

for (i = 0; i < 5; i++) {

   if (queue_dequeue(&queue, (void **)&data) == 0)
      free(data);
   else
      return 1;

}

print_queue(&queue);

fprintf(stdout, "Dodanie do kolejki 100 i 200\n");

if ((data = (int *)malloc(sizeof(int))) == NULL)
   return 1;

*data = 100;

if (queue_enqueue(&queue, data) != 0)
   return 1;

if ((data = (int *)malloc(sizeof(int))) == NULL)
   return 1;

*data = 200;

if (queue_enqueue(&queue, data) != 0)
   return 1;

print_queue(&queue);

if ((data = queue_peek(&queue)) != NULL)
   fprintf(stdout, "Podejrzenie elementu z gowy...Warto%03d\n", *data);
else
   fprintf(stdout, "Podejrzenie elementu z grupy... Warto=NULL\n");

print_queue(&queue);

fprintf(stdout, "Usunicie z kolejki wszystkich elementw.\n");

while (queue_size(&queue) > 0) {

   if (queue_dequeue(&queue, (void **)&data) == 0)
      free(data);
   
}

if ((data = queue_peek(&queue)) != NULL)
   fprintf(stdout, "Podgldanie pustej kolejki...Warto%03d\n", *data);
else
   fprintf(stdout, "Podgldanie puste kolejki...Value=NULL\n");

/*****************************************************************************
*                                                                            *
*  Usunicie kolejki.                                                        *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Usunicie kolejki.\n");
queue_destroy(&queue);

return 0;

}
