/*****************************************************************************
*                                                                            *
*  --------------------------------- rsa.c --------------------------------  *
*                                                                            *
*****************************************************************************/

#include "encrypt.h"

/*****************************************************************************
*                                                                            *
*  -------------------------------- modexp --------------------------------  *
*                                                                            *
*****************************************************************************/

static Huge modexp(Huge a, Huge b, Huge n) {

Huge               y;

/*****************************************************************************
*                                                                            *
*  Wyliczamy pow(a, b) % n korzystajc z metody binarnego kwadratu           *
*  i mnoenia.                                                               *
*                                                                            *
*****************************************************************************/

y = 1;

while (b != 0) {

   /**************************************************************************
   *                                                                         *
   *  Dla kadej 1 z b doczamy do y.                                       *
   *                                                                         *
   **************************************************************************/

   if (b & 1)
      y = (y * a) % n;

   /**************************************************************************
   *                                                                         *
   *  Dla kadego bitu z b podnosimy a do kwadratu.                          *
   *                                                                         *
   **************************************************************************/

   a = (a * a) % n;

   /**************************************************************************
   *                                                                         *
   *  Przygotowujemy sie na nastpny bit z b.                                *
   *                                                                         *
   **************************************************************************/

   b = b >> 1;

}

return y;

}

/*****************************************************************************
*                                                                            *
*  ----------------------------- rsa_encipher -----------------------------  *
*                                                                            *
*****************************************************************************/

void rsa_encipher(Huge plaintext, Huge *ciphertext, RsaPubKey pubkey) {

*ciphertext = modexp(plaintext, pubkey.e, pubkey.n);

return;

}

/*****************************************************************************
*                                                                            *
*  ----------------------------- rsa_decipher -----------------------------  *
*                                                                            *
*****************************************************************************/

void rsa_decipher(Huge ciphertext, Huge *plaintext, RsaPriKey prikey) {

*plaintext = modexp(ciphertext, prikey.d, prikey.n);

return;

}
