/*****************************************************************************
*                                                                            *
*  ------------------------------- qksort.c -------------------------------  *
*                                                                            *
*****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "sort.h"

/*****************************************************************************
*                                                                            *
*  ------------------------------ compare_int -----------------------------  *
*                                                                            *
*****************************************************************************/

static int compare_int(const void *int1, const void *int2) {

/*****************************************************************************
*                                                                            *
*  Porwnanie dwch liczb cakowitych (z podziaem wg potrjnej mediany).    *
*                                                                            *
*****************************************************************************/

if (*(const int *)int1 > *(const int *)int2)
   return 1;
else if (*(const int *)int1 < *(const int *)int2)
   return -1;
else
   return 0;

}

/*****************************************************************************
*                                                                            *
*  ------------------------------- partition ------------------------------  *
*                                                                            *
*****************************************************************************/

static int partition(void *data, int esize, int i, int k, int (*compare)
   (const void *key1, const void *key2)) {

char               *a = data;

void               *pval,
                   *temp;

int                r[3];

/*****************************************************************************
*                                                                            *
*  Rezerwacja pamicie na warto podziau i zamian wartoci miejscami.     *
*                                                                            *
*****************************************************************************/

if ((pval = malloc(esize)) == NULL)
   return -1;

if ((temp = malloc(esize)) == NULL) {

   free(pval);
   return -1;

}

/*****************************************************************************
*                                                                            *
*  Znalezienie wartoci podziau metod potrjnej mediany.                   *
*                                                                            *
*****************************************************************************/

r[0] = (rand() % (k - i + 1)) + i;
r[1] = (rand() % (k - i + 1)) + i;
r[2] = (rand() % (k - i + 1)) + i;
issort(r, 3, sizeof(int), compare_int);
memcpy(pval, &a[r[1] * esize], esize);

/*****************************************************************************
*                                                                            *
*  Utworzenie dwch czci wok wartoci podziau.                          *
*                                                                            *
*****************************************************************************/

i--;
k++;

while (1) {

   /**************************************************************************
   *                                                                         *
   *  Przechodzimy w lewo, a znajdziemy element znajdujcy si              *
   *  w niewaciwej czci.                                                 *
   *                                                                         *
   **************************************************************************/

   do {

      k--;

   } while (compare(&a[k * esize], pval) > 0);

   /**************************************************************************
   *                                                                         *
   *  Przechodzimy w prawo, a znajdziemy element znajdujcy si             *
   *  w niewaciwej czci.                                                 *
   *                                                                         *
   **************************************************************************/

   do {

      i++;

   } while (compare(&a[i * esize], pval) < 0);

   if (i >= k) {

      /***********************************************************************
      *                                                                      *
      *  Koniec dzielenia, kiedy zetkn si liczniki lewy i prawy.           *
      *                                                                      *
      ***********************************************************************/

      break;

      }

   else {

      /***********************************************************************
      *                                                                      *
      *  Zamaian miejscami elementw z lewego i prawego licznika.            *
      *                                                                      *
      ***********************************************************************/

      memcpy(temp, &a[i * esize], esize);
      memcpy(&a[i * esize], &a[k * esize], esize);
      memcpy(&a[k * esize], temp, esize);

   }

}

/*****************************************************************************
*                                                                            *
*  Zwolnienie pamici zarezerwowanej na podzia.                             *
*                                                                            *
*****************************************************************************/

free(pval);
free(temp);

/*****************************************************************************
*                                                                            *
*  Zwrcenie pooenia dzielcego czci.                                    *
*                                                                            *
*****************************************************************************/

return k;

}

/*****************************************************************************
*                                                                            *
*  -------------------------------- qksort --------------------------------  *
*                                                                            *
*****************************************************************************/

int qksort(void *data, int size, int esize, int i, int k, int (*compare)
   (const void *key1, const void *key2)) {

int                j;

/*****************************************************************************
*                                                                            *
*  Jeli niemoliwe dalsze podziay, koniec rekurencji.                      *
*                                                                            *
*****************************************************************************/

if (i < k) {

   /**************************************************************************
   *                                                                         *
   *  Sprawdzenie, gdzie naley dokona podziau.                            *
   *                                                                         *
   **************************************************************************/

   if ((j = partition(data, esize, i, k, compare)) < 0)
      return -1;

   /**************************************************************************
   *                                                                         *
   *  Rekurencyjne sortowanie lewej czci.                                  *
   *                                                                         *
   **************************************************************************/

   if (qksort(data, size, esize, i, j, compare) < 0)
      return -1;

   /**************************************************************************
   *                                                                         *
   *  Rekurencyjne sortowanie prawej czci.                                 *
   *                                                                         *
   **************************************************************************/

   if (qksort(data, size, esize, j + 1, k, compare) < 0)
      return -1;

}

return 0;

}
