/*****************************************************************************
*                                                                            *
*  ------------------------------- parcels.c ------------------------------  *
*                                                                            *
*****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "parcel.h"
#include "parcels.h"
#include "pqueue.h"

/*****************************************************************************
*                                                                            *
*  ------------------------------ get_parcel ------------------------------  *
*                                                                            *
*****************************************************************************/

int get_parcel(PQueue *parcels, Parcel *parcel) {

Parcel             *data;

if (pqueue_size(parcels) == 0)

   /**************************************************************************
   *                                                                         *
   *  Zwracamy informacj, e nie ma adnych paczek.                         *
   *                                                                         *
   **************************************************************************/

   return -1;

else {

   if (pqueue_extract(parcels, (void **)&data) != 0)

      /***********************************************************************
      *                                                                      *
      *  Nie udao si pobra paczki.                                        *
      *                                                                      *
      ***********************************************************************/

      return -1;

   else {

      /***********************************************************************
      *                                                                      *
      *  Zwrot paczki o najwyszym priorytecie.                              *
      *                                                                      *
      ***********************************************************************/

      memcpy(parcel, data, sizeof(Parcel));
      free(data);

   }

}

return 0;

}

/*****************************************************************************
*                                                                            *
*  ------------------------------ put_parcel ------------------------------  *
*                                                                            *
*****************************************************************************/

int put_parcel(PQueue *parcels, const Parcel *parcel) {

Parcel             *data;

/*****************************************************************************
*                                                                            *
*  Alokacja pamici na paczk.                                               *
*                                                                            *
*****************************************************************************/

if ((data = (Parcel *)malloc(sizeof(Parcel))) == NULL)
   return -1;

/*****************************************************************************
*                                                                            *
*  Wstawienie paczki do kolejki priorytetowej.                               *
*                                                                            *
*****************************************************************************/

memcpy(data, parcel, sizeof(Parcel));

if (pqueue_insert(parcels, data) != 0)
   return -1;

return 0;

}
