/*****************************************************************************
*                                                                            *
*  --------------------------------- mst.c --------------------------------  *
*                                                                            *
*****************************************************************************/

#include <float.h>
#include <stdlib.h>

#include "graph.h"
#include "graphalg.h"
#include "list.h"

/*****************************************************************************
*                                                                            *
*  ---------------------------------- mst ---------------------------------  *
*                                                                            *
*****************************************************************************/

int mst(Graph *graph, const MstVertex *start, List *span, int (*match)(const
   void *key1, const void *key2)) {

AdjList            *adjlist;

MstVertex          *mst_vertex,
                   *adj_vertex;

ListElmt           *element,
                   *member;

double             minimum;

int                found,
                   i;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja wszystkich wzw grafu.                                    *
*                                                                            *
*****************************************************************************/

found = 0;

for (element = list_head(&graph_adjlists(graph)); element != NULL; element =
   list_next(element)) {

   mst_vertex = ((AdjList *)list_data(element))->vertex;

   if (match(mst_vertex, start)) {

      /***********************************************************************
      *                                                                      *
      *  Inicjalizacja wza pocztkowego.                                   *
      *                                                                      *
      ***********************************************************************/

      mst_vertex->color = white;
      mst_vertex->key = 0;
      mst_vertex->parent = NULL;
      found = 1;

      }

   else {

      /***********************************************************************
      *                                                                      *
      *  Inicjalizacja wzw poza wzem pocztkowym.                       *
      *                                                                      *
      ***********************************************************************/

      mst_vertex->color = white;
      mst_vertex->key = DBL_MAX;
      mst_vertex->parent = NULL;

   }

}

/*****************************************************************************
*                                                                            *
*  Jeli nie znaleziono wza pocztkowego, koczymy.                        *
*                                                                            *
*****************************************************************************/

if (!found)
   return -1;

/*****************************************************************************
*                                                                            *
*  Wyznaczamy drzewo minimalne algorytmem Prim'a.                            *
*                                                                            *
*****************************************************************************/

i = 0;

while (i < graph_vcount(graph)) {

   /**************************************************************************
   *                                                                         *
   *  Wybieramy biay wze o najmniejszej wartoci klucza.                  *
   *                                                                         *
   **************************************************************************/

   minimum = DBL_MAX;

   for (element = list_head(&graph_adjlists(graph)); element != NULL; element
      = list_next(element)) {

      mst_vertex = ((AdjList *)list_data(element))->vertex;

      if (mst_vertex->color == white && mst_vertex->key < minimum) {

         minimum = mst_vertex->key;
         adjlist = list_data(element);

      }

   }

   /**************************************************************************
   *                                                                         *
   *  Zaczerniamy wybrany wze.                                             *
   *                                                                         *
   **************************************************************************/

   ((MstVertex *)adjlist->vertex)->color = black;

   /**************************************************************************
   *                                                                         *
   *  Przegldamy wszystkie wzy ssiadujce z wzem wybranym.             *
   *                                                                         *
   **************************************************************************/

   for (member = list_head(&adjlist->adjacent); member != NULL; member =
      list_next(member)) {

      adj_vertex = list_data(member);

      /***********************************************************************
      *                                                                      *
      *  Znalezienie wza ssiadujcego z listy struktur ssiedztwa.        *
      *                                                                      *
      ***********************************************************************/

      for (element = list_head(&graph_adjlists(graph)); element != NULL;
         element = list_next(element)) {

         mst_vertex = ((AdjList *)list_data(element))->vertex;

         if (match(mst_vertex, adj_vertex)) {

            /*****************************************************************
            *                                                                *
            *  Decydujemy, czy zmieniamy warto klucza i rodzica wza      *
            *  ssiedniego z listy struktur list ssiedztwa.                 *
            *                                                                *
            *****************************************************************/

            if (mst_vertex->color == white && adj_vertex->weight <
               mst_vertex->key) {

               mst_vertex->key = adj_vertex->weight;
               mst_vertex->parent = adjlist->vertex;

            }

            break;

         }

      }

   }

   /**************************************************************************
   *                                                                         *
   *  Przygotowujemy si do wyboru nastpnego wza.                         *
   *                                                                         *
   **************************************************************************/

   i++;

}

/*****************************************************************************
*                                                                            *
*  adujemy drzewo minimalne na list.                                       *
*                                                                            *
*****************************************************************************/

list_init(span, NULL);

for (element = list_head(&graph_adjlists(graph)); element != NULL; element =
   list_next(element)) {

   /**************************************************************************
   *                                                                         *
   *  adowanie wszystkich czarnych wzw z listy ssiedztwa.               *
   *                                                                         *
   **************************************************************************/

   mst_vertex = ((AdjList *)list_data(element))->vertex;

   if (mst_vertex->color == black) {

      if (list_ins_next(span, list_tail(span), mst_vertex) != 0) {

         list_destroy(span);
         return -1;

      }

   }

}

return 0;

}
