/*****************************************************************************
*                                                                            *
*  ex-1.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Opis: Ilustracja uycia list powizanych (rozdzia 5.)                    *
*                                                                            *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "list.h"

/*****************************************************************************
*                                                                            *
*  ------------------------------ print_list ------------------------------  *
*                                                                            *
*****************************************************************************/

static void print_list(const List *list) {

ListElmt           *element;

int                *data,
                   i;

/*****************************************************************************
*                                                                            *
*  Pokazanie listy powizanej.                                               *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Rozmiar listy to %d\n", list_size(list));

i = 0;
element = list_head(list);

while (1) {

   data = list_data(element);
   fprintf(stdout, "list[%03d]=%03d\n", i, *data);

   i++;

   if (list_is_tail(element))
      break;
   else
      element = list_next(element);

}

return;

}

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

List               list;
ListElmt           *element;

int                *data,
                   i;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja listy powizanej.                                           *
*                                                                            *
*****************************************************************************/

list_init(&list, free);

/*****************************************************************************
*                                                                            *
*  Operacje na licie powizanej.                                            *
*                                                                            *
*****************************************************************************/

element = list_head(&list);

for (i = 10; i > 0; i--) {

   if ((data = (int *)malloc(sizeof(int))) == NULL)
      return 1;

   *data = i;

   if (list_ins_next(&list, NULL, data) != 0)
      return 1;

}

print_list(&list);

element = list_head(&list);

for (i = 0; i < 7; i++)
   element = list_next(element);

data = list_data(element);
fprintf(stdout, "Usuwanie elementu zza elementu zawierajcego %03d\n", *data);

if (list_rem_next(&list, element, (void **)&data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Wstawianie 011 na koniec listy\n");

*data = 11;
if (list_ins_next(&list, list_tail(&list), data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Usuwanie elementu zza elementu pierwszego\n");

element = list_head(&list);
if (list_rem_next(&list, element, (void **)&data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Wstawianie 012 w gowie listy\n");

*data = 12;
if (list_ins_next(&list, NULL, data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Iteracja i usuwanie czwartego elementu\n");

element = list_head(&list);
element = list_next(element);
element = list_next(element);

if (list_rem_next(&list, element, (void **)&data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Wstawianie 013 za pierwszym elementem\n");

*data = 13;
if (list_ins_next(&list, list_head(&list), data) != 0)
   return 1;

print_list(&list);

i = list_is_head(&list, list_head(&list));
fprintf(stdout, "Testowanie list_is_head...Warto=%d (1=OK)\n", i);
i = list_is_head(&list, list_tail(&list));
fprintf(stdout, "Testowanie list_is_head...Warto=%d (0=OK)\n", i);
i = list_is_tail(list_tail(&list));
fprintf(stdout, "Testowanie list_is_tail...Warto=%d (1=OK)\n", i);
i = list_is_tail(list_head(&list));
fprintf(stdout, "Testowanie list_is_tail...Warto=%d (0=OK)\n", i);

/*****************************************************************************
*                                                                            *
*  Usunicie listy powizanej.                                               *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Usuwanie listy powizanej\n");
list_destroy(&list);

return 0;

}
