/*****************************************************************************
*                                                                            *
*  ex-1.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Opis: Ilustruje uycie list podwjnie powizanych (rozdzia 5).           *
*                                                                            *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "dlist.h"

/*****************************************************************************
*                                                                            *
*  ------------------------------ print_list ------------------------------  *
*                                                                            *
*****************************************************************************/

void print_list(const DList *list) {

DListElmt          *element;

int                *data,
                   i;

/*****************************************************************************
*                                                                            *
*  Pokazanie listy podwjnie powizanej.                                     *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Rozmiar listy to %d\n", dlist_size(list));

i = 0;
element = dlist_head(list);

while (1) {

   data = dlist_data(element);
   fprintf(stdout, "list[%03d]=%03d\n", i, *data);

   i++;

   if (dlist_is_tail(element))
      break;
   else
      element = dlist_next(element);

}

return;

}

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

DList              list;
DListElmt          *element;

int                *data,
                   i;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja listy podwjnie powizanej.                                 *
*                                                                            *
*****************************************************************************/

dlist_init(&list, free);

/*****************************************************************************
*                                                                            *
*  Wybrane operacje na licie podwjnie powizanej.                          *
*                                                                            *
*****************************************************************************/

element = dlist_head(&list);

for (i = 10; i > 0; i--) {

   if ((data = (int *)malloc(sizeof(int))) == NULL)
      return 1;

   *data = i;

   if (dlist_ins_prev(&list, dlist_head(&list), data) != 0)
      return 1;

}

print_list(&list);

element = dlist_head(&list);

for (i = 0; i < 8; i++)
   element = dlist_next(element);

data = dlist_data(element);
fprintf(stdout, "Usuwanie elementu zza elementu zawierajcego %03d\n", *data);

if (dlist_remove(&list, element, (void **)&data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Wstawienie 011 jako ogona listy\n");

*data = 11;
if (dlist_ins_next(&list, dlist_tail(&list), data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Usuwanie elementu z ogona listy\n");

element = dlist_tail(&list);
if (dlist_remove(&list, element, (void **)&data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Wstawianie 012 tu przed ogonem listy\n");

*data = 12;
if (dlist_ins_prev(&list, dlist_tail(&list), data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Iteracja i usuwanie czwartego elementu\n");

element = dlist_head(&list);
element = dlist_next(element);
element = dlist_prev(element);
element = dlist_next(element);
element = dlist_prev(element);
element = dlist_next(element);
element = dlist_next(element);
element = dlist_next(element);

if (dlist_remove(&list, element, (void **)&data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Wstawienie 013 przed elementem pierwszym\n");

*data = 13;
if (dlist_ins_prev(&list, dlist_head(&list), data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Usuwanie elementu z gowy listy\n");

if (dlist_remove(&list, dlist_head(&list), (void **)&data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Wstawianie 014 tu za gow listy\n");
*data = 14;

if (dlist_ins_next(&list, dlist_head(&list), data) != 0)
   return 1;

print_list(&list);

fprintf(stdout, "Wstawianie 015 dwa elementy za gow listy\n");

if ((data = (int *)malloc(sizeof(int))) == NULL)
   return 1;

*data = 15;
element = dlist_head(&list);
element = dlist_next(element);

if (dlist_ins_next(&list, element, data) != 0)
   return 1;

print_list(&list);

i = dlist_is_head(dlist_head(&list));
fprintf(stdout, "Testowanie dlist_is_head...Warto=%d (1=OK)\n", i);
i = dlist_is_head(dlist_tail(&list));
fprintf(stdout, "Testowanie dlist_is_head...Warto=%d (0=OK)\n", i);
i = dlist_is_tail(dlist_tail(&list));
fprintf(stdout, "Testowanie dlist_is_tail...Warto=%d (1=OK)\n", i);
i = dlist_is_tail(dlist_head(&list));
fprintf(stdout, "Testowanie dlist_is_tail...Warto=%d (0=OK)\n", i);

/*****************************************************************************
*                                                                            *
*  Usunicie listy podwjnie powizanej.                                     *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Usuwanie listy podwjnie powizanej.\n");
dlist_destroy(&list);

return 0;

}
