/*****************************************************************************
*                                                                            *
*  ex-1.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Opis: Ilustracja kompresji danych (rozdzia 14.)                          *
*                                                                            *
*****************************************************************************/

#include <ctype.h>
#include <stdio.h>

#include "compress.h"

/*****************************************************************************
*                                                                            *
*  Rozmiar kompresowanych danych.                                            *
*                                                                            *
*****************************************************************************/

#define            DATSIZ           500000

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

FILE               *fp;

unsigned char      original[DATSIZ],
                   *compressed,
                   *restored;

int                csize,
                   osize,
                   rsize,
                   c,
                   i;

/*****************************************************************************
*                                                                            *
*  Odczyt jakich danych do kompresji.                                       *
*                                                                            *
*****************************************************************************/

if ((fp = fopen("sample.txt", "r")) == NULL)
   return 1;

i = 0;

while ((c = getc(fp)) != EOF && i < DATSIZ) {

   original[i] = c;
   i++;

}

osize = i;
fclose(fp);

/*****************************************************************************
*                                                                            *
*  Kompresja danych za pomoc kodowania Huffmana.                            *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Kompresowanie za pomoc kodowania Huffmana\n");
fprintf(stdout, "Kompresowanie...");

if ((csize = huffman_compress(original, &compressed, osize)) < 0) {

   fprintf(stdout, "\n");
   return 1;

}

fprintf(stdout, "Zakoczono\n");
fprintf(stdout, "Dekompresowanie...");

if ((rsize = huffman_uncompress(compressed, &restored)) < 0) {

   fprintf(stdout, "\n");
   free(compressed);
   return 1;

}

fprintf(stdout, "Zakoczono\n");
fprintf(stdout, "osize=%d, csize=%d, rsize=%d\n", osize, csize, rsize);

if (rsize != osize) {

   fprintf(stdout, "Danych nie udao si poprawnie odczyta\n");
   free(compressed);
   free(restored);
   return 1;

   }

else {

   for (i = 0; i < rsize; i++) {

      if (original[i] != restored[i]) {

         fprintf(stdout, "Dane nie zostay poprawnie odczytane\n");

         if (isgraph(original[i]))
            fprintf(stdout, "original[%d]=\"%c\"\n", i, original[i]);
         else
            fprintf(stdout, "original[%d]=0x%02x\n", i, original[i]);

         if (isgraph(restored[i]))
            fprintf(stdout, "restored[%d]=\"%c\"\n", i, restored[i]);
         else
            fprintf(stdout, "restored[%d]=0x%02x\n", i, restored[i]);

         free(compressed);
         free(restored);
         return 1;

      }

   }

}

fprintf(stdout, "Dane poprawnie zinterpretowano.\n");

free(compressed);
free(restored);

/*****************************************************************************
*                                                                            *
*  Compress some data using LZ77.                                            *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Kompresowanie za pomoc LZ77\n");
fprintf(stdout, "Kompresowanie...");

if ((csize = lz77_compress(original, &compressed, osize)) < 0)
   return 1;

fprintf(stdout, "Zakoczono\n");
fprintf(stdout, "Dekompresowanie...");

if ((rsize = lz77_uncompress(compressed, &restored)) < 0) {

   fprintf(stdout, "\n");
   free(compressed);
   return 1;

}

fprintf(stdout, "Zakoczono\n");
fprintf(stdout, "osize=%d, csize=%d, rsize=%d\n", osize, csize, rsize);

if (rsize != osize) {

   fprintf(stdout, "Dane nie zostay poprawnie odzyskane\n");
   free(compressed);
   free(restored);
   return 1;

   }

else {

   for (i = 0; i < rsize; i++) {

      if (original[i] != restored[i]) {

         fprintf(stdout, "Dane nie zostay poprawnie odzyskane\n");

         if (isgraph(original[i]))
            fprintf(stdout, "original[%d]=\"%c\"\n", i, original[i]);
         else
            fprintf(stdout, "original[%d]=0x%02x\n", i, original[i]);

         if (isgraph(restored[i]))
            fprintf(stdout, "restored[%d]=\"%c\"\n", i, restored[i]);
         else
            fprintf(stdout, "restored[%d]=0x%02x\n", i, restored[i]);

         free(compressed);
         free(restored);
         return 1;

      }

   }

}

fprintf(stdout, "Dane odzyskano poprawnie\n");

free(compressed);
free(restored);

return 0;

}
