/*****************************************************************************
*                                                                            *
*  ex-1.c                                                                    *
*  ======                                                                    *
*                                                                            *
*  Opis: Ilustruje uycie acuchowych tablic asocjacyjnych (rozdzia 8.)    *
*                                                                            *
*****************************************************************************/

#include <stdio.h>

#include "chtbl.h"
#include "list.h"

/*****************************************************************************
*                                                                            *
*  Rozmiar acuchowych tablic asocjacyjnych.                                *
*                                                                            *
*****************************************************************************/

#define            TBLSIZ               11

/*****************************************************************************
*                                                                            *
*  ------------------------------ match_char ------------------------------  *
*                                                                            *
*****************************************************************************/

static int match_char(const void *char1, const void *char2) {

/*****************************************************************************
*                                                                            *
*  Compare two characters.                                                   *
*                                                                            *
*****************************************************************************/

return (*(const char *)char1 == *(const char *)char2);

}

/*****************************************************************************
*                                                                            *
*  -------------------------------- h_char --------------------------------  *
*                                                                            *
*****************************************************************************/

static int h_char(const void *key) {

/*****************************************************************************
*                                                                            *
*  Bardzo prosta funkcja mieszajca.                                         *
*                                                                            *
*****************************************************************************/

return *(const char *)key % TBLSIZ;

}

/*****************************************************************************
*                                                                            *
*  ------------------------------ print_table -----------------------------  *
*                                                                            *
*****************************************************************************/

static void print_table(const CHTbl *htbl) {

ListElmt           *element;

int                i;

/*****************************************************************************
*                                                                            *
*  Wywietlenie acuchowej tablicy asocjacyjnej.                            *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Rozmiar tablicy to %d\n", chtbl_size(htbl));

for (i = 0; i < TBLSIZ; i++) {

   fprintf(stdout, "Bucket[%03d]=", i);

   for (element = list_head(&htbl->table[i]); element != NULL; element =
      list_next(element)) {

      fprintf(stdout, "%c", *(char *)list_data(element));

   }

   fprintf(stdout, "\n");

}

return;

}

/*****************************************************************************
*                                                                            *
*  --------------------------------- main ---------------------------------  *
*                                                                            *
*****************************************************************************/

int main(int argc, char **argv) {

CHTbl              htbl;

char               *data,
                   c;

int                retval,
                   i;

/*****************************************************************************
*                                                                            *
*  Inicjalizacja acuchowej tablicy asocjacyjnej.                           *
*                                                                            *
*****************************************************************************/

if (chtbl_init(&htbl, TBLSIZ, h_char, match_char, free) != 0)
   return 1;

/*****************************************************************************
*                                                                            *
*  Wybrane operacje na acuchowej tablicy asocjacyjnej.                     *
*                                                                            *
*****************************************************************************/

for (i = 0; i < TBLSIZ; i++) {

   if ((data = (char *)malloc(sizeof(char))) == NULL)
      return 1;

   *data = ((5 + (i * 6)) % 23) + 'A';

   if (chtbl_insert(&htbl, data) != 0)
      return 1;

   print_table(&htbl);

}

for (i = 0; i < TBLSIZ; i++) {

   if ((data = (char *)malloc(sizeof(char))) == NULL)
      return 1;

   *data = ((3 + (i * 4)) % 23) + 'a';

   if (chtbl_insert(&htbl, data) != 0)
      return 1;

   print_table(&htbl);

}

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'd';

if ((retval = chtbl_insert(&htbl, data)) != 0)
   free(data);

fprintf(stdout, "Prba ponownego wstawienia d...Warto=%d (1=OK)\n", retval);

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'G';

if ((retval = chtbl_insert(&htbl, data)) != 0)
   free(data);

fprintf(stdout, "Prba ponownego wstawienia G...Warto=%d (1=OK)\n", retval);

fprintf(stdout, "Usuwanie d, G, oraz S\n");

c = 'd';
data = &c;

if (chtbl_remove(&htbl, (void **)&data) == 0)
   free(data);

c = 'G';
data = &c;

if (chtbl_remove(&htbl, (void **)&data) == 0)
   free(data);

c = 'S';
data = &c;

if (chtbl_remove(&htbl, (void **)&data) == 0)
   free(data);

print_table(&htbl);

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'd';

if ((retval = chtbl_insert(&htbl, data)) != 0)
   free(data);

fprintf(stdout, "Prba ponownego wstawienia d...Warto=%d (0=OK)\n", retval);

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'G';

if ((retval = chtbl_insert(&htbl, data)) != 0)
   free(data);

fprintf(stdout, "Prba ponownego wstawienia G...Warto=%d (0=OK)\n", retval);

print_table(&htbl);

fprintf(stdout, "Wstawianie X i Y\n");

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'X';

if (chtbl_insert(&htbl, data) != 0)
   return 1;

if ((data = (char *)malloc(sizeof(char))) == NULL)
   return 1;

*data = 'Y';

if (chtbl_insert(&htbl, data) != 0)
   return 1;

print_table(&htbl);

c = 'X';
data = &c;

if (chtbl_lookup(&htbl, (void **)&data) == 0)
   fprintf(stdout, "Znaleziono wystpienie X\n");
else
   fprintf(stdout, "Nie znaleziono wystpienia X\n");

c = 'Z';
data = &c;

if (chtbl_lookup(&htbl, (void **)&data) == 0)
   fprintf(stdout, "Znaleziono wystpienie Z\n");
else
   fprintf(stdout, "Nie znaleziono wystpienia Z\n");

/*****************************************************************************
*                                                                            *
*  Destroy the chained hash table.                                           *
*                                                                            *
*****************************************************************************/

fprintf(stdout, "Usuwanie tablicy asocjacyjnej\n");
chtbl_destroy(&htbl);

return 0;

}
