/*****************************************************************************
*                                                                            *
*  ------------------------------- events.c -------------------------------  *
*                                                                            *
*****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "event.h"
#include "events.h"
#include "queue.h"

/*****************************************************************************
*                                                                            *
*  ---------------------------- receive_event -----------------------------  *
*                                                                            *
*****************************************************************************/

int receive_event(Queue *events, const Event *event) {

Event              *new_event;

/*****************************************************************************
*                                                                            *
*  Alokacja pamici na zdarzenie.                                            *
*                                                                            *
*****************************************************************************/

if ((new_event = (Event *)malloc(sizeof(Event))) == NULL)
   return -1;

/*****************************************************************************
*                                                                            *
*  Robimy kopi zdarzenia i wstawiamy je do kolejki.                         *
*                                                                            *
*****************************************************************************/

memcpy(new_event, event, sizeof(Event));

if (queue_enqueue(events, new_event) != 0)
   return -1;

return 0;

}

/*****************************************************************************
*                                                                            *
*  ---------------------------- process_event -----------------------------  *
*                                                                            *
*****************************************************************************/

int process_event(Queue *events, int (*dispatch)(Event *event)) {

Event              *event;

if (queue_size(events) == 0)

   /**************************************************************************
   *                                                                         *
   *  Zwracamy informacj, e nie ma zdarze wymagajcych obsugi.           *
   *                                                                         *
   **************************************************************************/

   return -1;

else {

   if (queue_dequeue(events, (void **)&event) != 0)

      /***********************************************************************
      *                                                                      *
      *  Zwracamy informacj, e nie udao si pobra zdarzenia.             *
      *                                                                      *
      ***********************************************************************/

      return -1;

   else {

      /***********************************************************************
      *                                                                      *
      *  Wywoujemy funkcj uytkownika obsugujc zdarzenie.               *
      *                                                                      *
      ***********************************************************************/

      dispatch(event);
      free(event);

   }

}

return 0;

}
