/*************************************************************************
 *  Kompilacja:  javac DirectedEdge.java
 *  Wykonanie:    java DirectedEdge
 *
 *  Niezmienne waone krawdzie skierowane.
 *
 *************************************************************************/

/**
 *  Klasa <tt>DirectedEdge</tt> reprezentuje krawd waon w grafie skierowanym.
 *  <p>
 *  Dodatkow dokumentacj znajdziesz w <a href="http://algs4.cs.princeton.edu/44sp">podrozdziale 4.4</a> ksiki
 *  <i>Algorytmy, wydanie czwarte</i> Roberta Sedgewicka i Kevina Wayne'a.
 */

public class DirectedEdge { 
    private final int v;
    private final int w;
    private final double weight;

   /**
     * Tworzy krawd skierowan z v do w o danej wadze.
     */
    public DirectedEdge(int v, int w, double weight) {
        this.v = v;
        this.w = w;
        this.weight = weight;
    }

   /**
     * Zwraca wierzchoek pocztkowy krawdzi.
     */
    public int from() {
        return v;
    }

   /**
     * Zwraca wierzchoek kocowy krawdzi.
     */
    public int to() {
        return w;
    }

   /**
     * Zwraca wag krawdzi.
     */
    public double weight() { return weight; }

   /**
     * Zwraca acuch znakw reprezentujcy dan krawd.
     */
    public String toString() {
        return v + "->" + w + " " + String.format("%5.2f", weight);
    }

   /**
     * Klient testowy.
     */
    public static void main(String[] args) {
        DirectedEdge e = new DirectedEdge(12, 23, 3.14);
        StdOut.println(e);
    }
}
