/*************************************************************************
 *  Kompilacja:  javac LZW.java
 *  Wykonanie:    java LZW - < input.txt   (compress)
 *  Wykonanie:    java LZW + < input.txt   (expand)
 *  Zalenoci: BinaryIn.java BinaryOut.java
 *
 *  Kompresuje lub rozpakowywuje metod LZW dane binarne ze standardowego wejcia.
 *
 *
 *************************************************************************/

public class LZW {
    private static final int R = 256;        // Liczba wejciowych znakw
    private static final int L = 4096;       // Liczba sw kodowych = 2^W
    private static final int W = 12;         // Dugo sowa kodowego

    public static void compress() { 
        String input = BinaryStdIn.readString();
        TST<Integer> st = new TST<Integer>();
        for (int i = 0; i < R; i++)
            st.put("" + (char) i, i);
        int code = R+1;  // R to sowo kodowe koca pliku

        while (input.length() > 0) {
            String s = st.longestPrefixOf(input);  // Znajdowanie maksymalnego przedrostka pasujcego do s.
            BinaryStdOut.write(st.get(s), W);      // Wywietlanie kodu dla s.
            int t = s.length();
            if (t < input.length() && code < L)    // Dodawanie s do tablicy symboli.
                st.put(input.substring(0, t + 1), code++);
            input = input.substring(t);            // Sprawdzanie poza s w danych wejciowych.
        }
        BinaryStdOut.write(R, W);
        BinaryStdOut.close();
    } 


    public static void expand() {
        String[] st = new String[L];
        int i; // Nastpna dostpna warto sowa kodowego

        // Inicjowanie tablicy symboli wszystkimi acuchami jednoznakowymi
        for (i = 0; i < R; i++)
            st[i] = "" + (char) i;
        st[i++] = "";                        

        int codeword = BinaryStdIn.readInt(W);
        String val = st[codeword];

        while (true) {
            BinaryStdOut.write(val);
            codeword = BinaryStdIn.readInt(W);
            if (codeword == R) break;
            String s = st[codeword];
            if (i == codeword) s = val + val.charAt(0);   // Sztuczka na potrzeby przypadku specjalnego
            if (i < L) st[i++] = val + s.charAt(0);
            val = s;
        }
        BinaryStdOut.close();
    }



    public static void main(String[] args) {
        if      (args[0].equals("-")) compress();
        else if (args[0].equals("+")) expand();
        else throw new RuntimeException("Niedozwolony argument wiersza polecen");
    }

}
