/***********************************************************************************
 *  Kompilacja: javac LSD.java
 *  Wykonanie:   java LSD < input.txt
 *
 *  Sortowanie pozycyjne metod LSD tablicy acuchw o dugoci w znakw z rozszerzonego zbioru ASCII.
 *
 *  % java LSD < words3.txt
 *  all
 *  bad
 *  bed
 *  bug
 *  dad
 *  ...
 *  yes
 *  yet
 *  zoo
 *
 ***********************************************************************************/

public class LSD {

    // Sortowanie pozycyjne metod LSD
    public static void sort(String[] a, int W) {
        int N = a.length;
        int R = 256;   // Rozmiar alfabetu opartego na rozszerzonym zbiorze ASCII
        String[] aux = new String[N];

        for (int d = W-1; d >= 0; d--) {
            // Sortowanie przez zliczanie oparte na d-tym znaku

            // Okrelanie liczby wystpie
            int[] count = new int[R+1];
            for (int i = 0; i < N; i++)
                count[a[i].charAt(d) + 1]++;

            // Obliczanie skumulowanych wartoci
            for (int r = 0; r < R; r++)
                count[r+1] += count[r];

            // Przenoszenie danych
            for (int i = 0; i < N; i++)
                aux[count[a[i].charAt(d)]++] = a[i];

            // Kopiowanie z powrotem
            for (int i = 0; i < N; i++)
                a[i] = aux[i];
        }
    }


    public static void main(String[] args) {
        String[] a = StdIn.readStrings();
        int N = a.length;

        // Sprawdzanie, czy acuchy maj sta dugo
        int W = a[0].length();
        for (int i = 0; i < N; i++)
            assert a[i].length() == W : "Lancuchy musza miec stala dlugosc";

        // Sortowanie acuchw
        sort(a, W);

        // Wywietlanie wynikw
        for (int i = 0; i < N; i++)
            System.out.println(a[i]);
    }
}
