/*************************************************************************
 *  Kompilacja:  javac KosarajuSCC.java
 *  Zalenoci: Digraph.java TransitiveClosure.java StdOut.java
 *
 *  Obliczanie silnie spjnych skadowych digrafu za pomoc
 *  algorytmu Kosaraju.
 *
 *  Zoono O(E + V).
 *
 *
 *************************************************************************/

public class KosarajuSCC {
    private boolean[] marked;     // marked[v] = czy odwiedzono wierzchoek v?
    private int[] id;             // id[v] = identyfikator silnej skadowej obejmujcej v
    private int count;            // Liczba silnie spjnych skadowych

    public KosarajuSCC(Digraph G) {

        // Wyznacza odwrotny porzdek postorder dla odwrconego grafu
        DepthFirstOrder dfs = new DepthFirstOrder(G.reverse());

        // Uruchamia wyszukiwanie w gb w grafie G; dziaanie oparte 
		// jest na odwrconym porzdku postorder
        marked = new boolean[G.V()];
        id = new int[G.V()];
        for (int v : dfs.reversePostorder()) {
            if (!marked[v]) {
                dfs(G, v);
                count++;
            }
        }

        // Sprawdza, czy id[] obejmuje silne skadowe
        assert check(G);
    }

    // Uruchamianie wyszukiwania w gb dla grafu G
    private void dfs(Digraph G, int v) { 
        marked[v] = true;
        id[v] = count;
        for (int w : G.adj(v)) {
            if (!marked[w]) dfs(G, w);
        }
    }

    // Zwracanie liczby silnie spjnych skadowych
    public int count() { return count; }

    // Czy v i w s silnie spjne?
    public boolean stronglyConnected(int v, int w) {
        return id[v] == id[w];
    }

    // Identyfikator silnej skadowej obejmujcej v
    public int id(int v) {
        return id[v];
    }

    // Czy tablica id[] obejmuje silnie spjne skadowe?
    private boolean check(Digraph G) {
        TransitiveClosure tc = new TransitiveClosure(G);
        for (int v = 0; v < G.V(); v++) {
            for (int w = 0; w < G.V(); w++) {
                if (stronglyConnected(v, w) != (tc.reachable(v, w) && tc.reachable(w, v)))
                    return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        int V = Integer.parseInt(args[0]);
        int E = Integer.parseInt(args[1]);
        Digraph G = new Digraph(V, E);
        StdOut.println(G);
        KosarajuSCC scc = new KosarajuSCC(G);
        StdOut.println("Silnie spojna skladowa = " + scc.count());
        for (int v = 0; v < G.V(); v++)
            StdOut.println(v + ": " + scc.id(v));
    }

}
