/*************************************************************************
 *  Kompilacja:  javac FlowEdge.java
 *  Wykonanie:    java FlowEdge
 *
 *  Krawdzie o okrelonej pojemnoci i przepywie w sieci przepywowej.
 *
 *************************************************************************/

/**
 *  Klasa <tt>FlowEdge</tt> reprezentuje krawd digrafu, majc okrelon pojemno i 
 *  pewien przepyw.
 *  <p>
 *  Dodatkow dokumentacj znajdziesz w <a href="/algs4/74or">podrozdziale 7.4</a> ksiki
 *  <i>Algorytmy, wydanie czwarte</i> Roberta Sedgewicka i Kevina Wayne'a.
 */


public class FlowEdge {
    private final int v;             // Wyjciowy wierzchoek
    private final int w;             // Docelowy wierzchoek
    private final double capacity;   // Pojemno
    private double flow;             // Przepyw

    public FlowEdge(int v, int w, double capacity) {
        if (capacity < 0) throw new RuntimeException("Ujemna pojemno krawdzi");
        this.v         = v;
        this.w         = w;  
        this.capacity  = capacity;
        this.flow      = 0;
    }

    public FlowEdge(int v, int w, double capacity, double flow) {
        if (capacity < 0) throw new RuntimeException("Ujemna pojemno krawdzi");
        this.v         = v;
        this.w         = w;  
        this.capacity  = capacity;
        this.flow      = flow;
    }

    // Metody dostpu
    public int from()         { return v;        }  
    public int to()           { return w;        }  
    public double capacity()  { return capacity; }
    public double flow()      { return flow;     }


    public int other(int vertex) {
        if      (vertex == v) return w;
        else if (vertex == w) return v;
        else throw new RuntimeException("Niedozwolony punkt kocowy");
    }

    public double residualCapacityTo(int vertex) {
        if      (vertex == v) return flow;
        else if (vertex == w) return capacity - flow;
        else throw new RuntimeException("Niedozwolony punkt kocowy");
    }

    public void addResidualFlowTo(int vertex, double delta) {
        if      (vertex == v) flow -= delta;
        else if (vertex == w) flow += delta;
        else throw new RuntimeException("Niedozwolony punkt kocowy");
    }


    public String toString() {
        return v + "->" + w + " " + flow + "/" + capacity;
    }


   /**
     * Klient testowy.
     */
    public static void main(String[] args) {
        FlowEdge e = new FlowEdge(12, 23, 3.14);
        StdOut.println(e);
    }

}
