// Przechowuje obiekt klasy XMLHttpRequest.
var xmlHttp = createXmlHttpRequestObject();

// Tworzy obiekt klasy XMLHttpRequest.
function createXmlHttpRequestObject() 
{
   // Będzie przechowywać odwołanie do obiektu klasy XMLHttpRequest.
   var xmlHttp;
   // Tworzy obiekt klasy XMLHttpRequest.
   try
   {
      // Przy założeniu, że strona jest otwierana w przegądarce IE7 lub jej nowszej wersji.
      xmlHttp = new XMLHttpRequest();
   }
   catch(e)
   {
      // Przy założeniu, że strona jest otwierana w przeglądarce IE6 lub starszej.
      try
      {
         xmlHttp = new ActiveXObject("Microsoft.XMLHttp");
      }
      catch(e) { }
   }
   // Zwraca utworzony obiekt lub wyświetla komunikat o błędzie.
   if (!xmlHttp)
      alert("Podczas tworzenia obiektu klasy XMLHttpRequest wystąpił błąd.");
   else 
      return xmlHttp;
}


// Odczytuje zawartość pliku umieszczonego na serwerze.
function process()
{
   // Kontynuuje tylko wtedy, gdy obiekt xmlHttp nie jest obiektem pustym.
   if (xmlHttp)
   {
      // Próbuje nawiązać połączenie z serwerem.
      try
      {
         // Inicjuje odczyt pliku z serwera.
         xmlHttp.open("GET", "phptest.php", true);
         xmlHttp.onreadystatechange = handleRequestStateChange;
         xmlHttp.send(null);
      }
      // W razie niepowodzenia wyświetla komunikat o błędzie.
      catch (e)
      {
         alert("Nie udało się nawiązać połączenia z serwerem:\n" + e.toString());
      }
   }
}

// Funkcja wywoływana po zmianie statutu żądania HTTP.
function handleRequestStateChange() 
{
   // Gdy metoda redyState zwraca wartość 4, odczytuje odpowiedź serwera.
   if (xmlHttp.readyState == 4) 
   {
      // Odczytuje odpowiedź tylko wtedy, gdy status żądania HTTP jest "OK".
      if (xmlHttp.status == 200) 
      {
         try
         {
            // Przetwarza odpowiedź nadesłaną przez serwer.
            handleServerResponse();
         }
         catch(e)
         {
            // Wyświetla komunikat o błędzie.
            alert("Błąd podczas odczytywania odpowiedzi: " + e.toString());
         }
      } 
      else
      {
         // Wyświetla wiadomość określającą status żądania.
         alert("Podczas pobierania danych wystąpił błąd:\n" + 
                  xmlHttp.statusText);
      }
   }
}

// Funkcja obsługująca odpowiedź serwera.
function handleServerResponse()
{
   // Odczytuje wiadomość wysłaną przez serwer.
   responseJSON = JSON.parse(xmlHttp.responseText);
   // Generuje odpowiedź w formacie HTML.
   var html = "";   
   // Iteracyjnie sprawdza wszystkie elementy tablic i tworzy strukturę strony HTML.
   for (var i=0; i<responseJSON.books.length; i++)
      html += responseJSON.books[i].title + 
                  ", " + responseJSON.books[i].isbn + "<br/>";
   // Pobiera odwołanie do znacznika <div> na stronie WWW.
   myDiv = document.getElementById("myDivElement");
   // Wyświetla dane wyjściowe w postaci dokumentu HTML.
   myDiv.innerHTML = "<p>Serwer mówi: </p>" + html;
}

