// Konstruktor obiektu XmlHttp, potrafiący pobierać ustawienia żądania:
// url - adres URL serwera
// contentType - rodzaj zawartości żądania
// type - sposób realizacji żądania (domyślnie metoda GET)
// data - opcjonalne parametry żądania 
// async - czy żądanie ma być realizowane asynchronicznie (domyślna wartość true)
// showErrors - wyświetlaj komunikaty o błędach
// complete - funkcja zwrotna wywoływana po zakończeniu realizacji żądania 
function XmlHttp(settings)
{   
   // Przechowuje obiekt klasy settings we właściwości klasy.
   this.settings = settings;
   
   // Nadpisuje domyślne ustawienia tymi, które zostają przekazane w postaci argumentu konstrukora.
   // Domyślny adres URL wskazuje na bieżącą stronę.
   var url = location.href;   
   if (settings.url) 
      url = settings.url;

   // Domyślny rodzaj zawartości jest rodzajem właściwym dla formularzy.
   var contentType = "application/x-www-form-urlencoded";
   if (settings.contentType) 
      contentType = settings.contentType;
   
   // Żądanie jest domyślnie realizowane za pomocą metody GET.
   var type = "GET";
   if(settings.type)
      type = settings.type;
   
   // Domyślnie nie przesyła żadnych parametrów.
   var data = null;
   if(settings.data)
   {
      data = settings.data;
      // Jeśli żądanie jest realizowane metodą GET, trzeba odpowiednio zmodyfikować adres URL.
      if(type == "GET")
         url = url + "?" + data;
   }
   
   // Domyślnie odpowiedź jest realizowana asynchronicznie.
   var async = true;
   if(settings.async)
      async = settings.async;
   
   // Domyślnie wyświetlane są wszystkie komunikaty o błędach infrastruktury.
   var showErrors = true;
   if(settings.showErrors)
      showErrors = settings.showErrors;
   
   // Tworzy obiekt klasy XmlHttpRequest.
   var xhr = XmlHttp.create();
   
   // Ustawia właściwości odpowiedzi.
   xhr.open(type, url, async);   
   xhr.onreadystatechange = onreadystatechange;
   xhr.setRequestHeader("Content-Type", contentType);
   xhr.send(data);

   // Funkcja odpowiedzialna za wyświetlanie błędów.   
   function displayError(message)
   {
      // Ignoruje błąd, jeśli zmienna showError przyjmuje wartość false.
      if (showErrors)
      {         
         // Wyświetla komunikat o błedzie. 
         alert("Wystąpił błąd: \n" + message);         
      }
   }

   // Funkcja odczytujaca odpowiedź serwera.   
   function readResponse()
   {
      try 
      {      
         // Pobiera rodzaj zawartości odpowiedzi.
         var contentType = xhr.getResponseHeader("Content-Type");
         // Tworzy obiekt json, jeśli odpowiedź tego wymaga.
         if (contentType == "application/json") 
         {
            response = JSON.parse(xhr.responseText);
         }
         // Pobiera element obiektu DOM, jeśli odpowiedź jest zapisana w formacie XML.
         else if (contentType == "text/xml") 
         {
            response = xhr.responseXml;
         }
         // Domyślnie pobiera odpowiedź w postaci pliku tekstowego.
         else 
         {
            response = xhr.responseText;
         }   
         // Wywołuje funkcję zwrotną, jeśli taka istnieje.
         if (settings.complete)
            settings.complete (xhr, response, xhr.status);
      }
      catch (e) 
      {
         displayError(e.toString());
      }
   }

   // Funkcja wywoływana w chwili zmiany statutu żądania.   
   function onreadystatechange()
   {
      // Gdy metoda redyState zwraca wartość 4, odczytuje odpowiedź serwera.
      if (xhr.readyState == 4) 
      {
         // Odczytuje odpowiedź tylko wtedy, gdy status żądania HTTP jest "OK".
         if (xhr.status == 200) 
         {
            try
            {
               // Odczytuje odpowiedź z serwera.
               readResponse();
            }
            catch(e)      
            {
               // Wyświetla komunikat o błędzie.
               displayError(e.toString());
            }
         }
         else
         {
            // Wyświetla komunikat o błędzie.
            displayError(xhr.statusText);
         }   
      }
   }
}

// Statyczna metoda zwracająca nowy obiekt klasy XMLHttpRequest.
XmlHttp.create = function()
{
   // Będzie przechowywać odwołanie do obiektu klasy XMLHttpRequest.
   var xmlHttp;
   // Tworzy obiekt klasy XMLHttpRequest.
   try
   {
      // Przy założeniu, że strona jest otwierana w przegądarce IE7 lub jej nowszej wersji.
      xmlHttp = new XMLHttpRequest();
   }
   catch(e)
   {
      // Przy założeniu, że strona jest otwierana w przeglądarce IE6 lub starszej.
      try
      {
         xmlHttp = new ActiveXObject("Microsoft.XMLHttp");
      }
      catch(e) { }
   }
   // Zwraca utworzony obiekt lub wyświetla komunikat o błędzie.
   if (!xmlHttp)
      alert("Podczas tworzenia obiektu klasy XMLHttpRequest wystąpił błąd.");
   else 
      return xmlHttp;
}