class Contact < Post

  validates_format_of :name, :with => /^.+ .+$/, 
    :message => "Musi zawierać pełną nazwę "
  validates_format_of :email, 
    :with => /^(([^@\s]+)@((?:[-a-z0-9]+\.)+[a-z]{2,}))?$/

  # Przeszukuje po pierwszej literze nazwiska
  def self.letter letter
    Contact.find :all, 
      :conditions => [ "name like ?", '% '+letter+'%' ]
  end
  
  # Zamienia "Scott Douglas Raymond" na "Raymond, Scott Douglas"
  def reversed_name
    names = name.split
    "#{names.pop}, #{names.join ' '}"
  end

end