module ApplicationHelper
  
  # Zwraca nazwę ikony (w katalogu public/images) dla 
  # danego rodzaju zawartości
  def icon_for content_type
    case content_type.to_s.strip
      when "image/jpeg"
        "JPG"
      when "application/vnd.ms-excel"
        "XLS"
      when "application/msword"
        "DOC"
      when "application/pdf"
        "PDF"
      else "Generic"
    end
  end

  # Zwraca tekstowy opis zawartości pliku
  def description_of content_type
    case content_type.to_s.strip
      when "image/jpeg"
        "grafika JPEG"
      when "application/vnd.ms-excel"
        "arkusz kalkulacyjny Excel"
      when "application/msword"
        "dokument Word "
      when "application/pdf"
        "plik PDF"
      else ""
    end
  end
  
  # Zwraca nazwę strony (dla tytułu oraz elemetów h1)
  def site_title
   'Intranet'
  end

  # Jeśli tytuł strony nie został ustawiony wprost w @page_title, jest 
  # wydedukowany z postu lub tytułu użytkowinka
  def page_title
    return @page_title if @page_title
    return @post.name if @post and !@post.new_record?
    return @user.name if @user and !@user.new_record?
    ''
  end

  # Zwraca div dla każdego przekazanego klucza, jeśli istnieje flash 
  # z takim kluczem
  def flash_div *keys
    divs = keys.select { |k| flash[k] }.collect do |k|
      content_tag :div, flash[k], :class => "flash #{k}"
    end
    divs.join
  end
  
  # Zwraca div z nazwą użytkownika oraz emblematem
  def user_thumb user
    img = tag("img", 
      :src => formatted_user_url(:id => user, :format =>'jpg'), 
      :class =>'user_picture', :alt => user.name)
    img_link = link_to img, user_url(:id => user)
    text_link = link_to user.short_name, user_url(:id => user)
    content_tag :div, "#{img_link}<br/>#{text_link}", 
      :class =>'user'
  end
  
  # Zwraca div
  def clear_div
    '<div class="clear"></div>'
  end

  # Generuje formularz używany do tworzenia oraz edycji wszystkich postów i użytkowników.
  # Dostarcza instancję LabelingFormBuilder 
  # (proszę porównać z lib/labeling_form_helper.rb).
  def standard_form name, object, &block
    url  = { :action    => object.new_record? ? "index" : "show" }
    html = { :class     => "standard",
             :style     => (@edit_on ? '' : "display: none;"),
             :multipart => true }
    concat form_tag(url, html) + "<fieldset>", block.binding
    unless object.new_record?
      concat '<input name="_method" type="hidden" value="put" />', 
        block.binding
    end
    yield LabelingFormBuilder.new(name, object, self, {}, block)
    concat "</fieldset>" + end_form_tag, block.binding
  end
  
  # Standardowy przycisk wysyłania oraz łącze do usuwania postów i użytkowników
  def standard_submit name=nil, object=nil
    name = post_type unless name
    object = @post unless object
    delete_link = link_to("Usuń", { :action =>'show' }, 
      :method => :delete, 
      :confirm => "Czy aby na pewno?", 
      :class => "delete")
    submit_tag("Zapisz #{name}") + 
      (object.new_record? ? "" : (" or " + delete_link))
  end

end