ActiveRecord::Schema.define( ) do

  create_table "users", :force => true do |t|
    t.column "email",        :string,   :limit => 100, 
                             :default => "",    :null => false
    t.column "password",     :string,   :limit => 100, 
                             :default => "",    :null => false
    t.column "name",         :string,   :limit => 40,  
                             :default => "",    :null => false
    t.column "phone",        :string,   :limit => 50,  
                             :default => "",    :null => false
    t.column "address",      :string,   :limit => 50,  
                             :default => "",    :null => false
    t.column "city",         :string,   :limit => 50,  
                             :default => "",    :null => false
    t.column "state",        :string,   :limit => 50,  
                             :default => "",    :null => false
    t.column "zip",          :string,   :limit => 50,  
                             :default => "",    :null => false
    t.column "picture_id",   :integer
    t.column "created_at",   :datetime
    t.column "updated_at",   :datetime
    t.column "status",       :string,   :limit => 50,  
                             :default => "",    :null => false
    t.column "last_active",  :datetime
    t.column "admin",        :boolean,                 
                             :default => false, :null => false
  end

  add_index "users", ["email"], :name => "email", :unique => true
  add_index "users", ["password"], :name => "password"

  create_table "posts", :force => true do |t|
    t.column "type",         :string,   :limit => 20
    t.column "post_id",      :integer
    t.column "created_at",   :datetime
    t.column "updated_at",   :datetime
    t.column "created_by",   :integer
    t.column "updated_by",   :integer
    t.column "name",         :string,   :limit => 128, 
                             :default => "Untitled", :null => false
    t.column "body",         :text, :null => false
    t.column "email",        :string,   :limit => 50,  
                             :default => "",         :null => false
    t.column "phone",        :string,   :limit => 50,  
                             :default => "",        :null => false
    t.column "start_date",   :date
    t.column "end_date",     :date
    t.column "attachment_id",           :integer
    t.column "attachment_filename",     :string
    t.column "attachment_content_type", :string,   :limit => 128
    t.column "attachment_size",         :integer
  end

  add_index "posts", ["type"], :name => "type"
  add_index "posts", ["created_at"], :name => "created_at"
  add_index "posts", ["updated_at"], :name => "updated_at"
  add_index "posts", ["post_id"], :name => "post_id"

  create_table "attachments", :force => true do |t|
    t.column "content",    :binary
    t.column "updated_at", :datetime
  end

end
