class ApplicationController < ActionController::Base

  include Authentication
  before_filter :require_login
  before_filter :set_system_announcement
  before_filter :check_for_valid_user
  
  private

    # Można usunąć to ogłoszenie podczas  
    # dostosowywania aplikacji do własnych potrzeb
    def set_system_announcement
      flash.now[:system_announcement] = 
        "To jest <strong>Ajax on Rails Intranet</strong>, <br/>
         wydana jako część <a href=\"http://scottraymond.net/\">
         <em>Ajax on Rails</em></a> z O&rsquo;Reilly Media."
    end

    # Metoda pomocnika sprawdza, czy obecny użytkownik może 
    # modyfikować +record+
    def can_edit? record
      # administratorzy mogą edytować wszystko
      return true if current_user.admin?
      case record.class.to_s
        when 'User'
          # zwykli użytkownicy nie mogą edytować innych użytkowników
          record.id == current_user.id
        when'Message'
          # wiadomości mogą być edytowane jedynie przez ich twórców
          record.created_by == current_user.id
        else true # Każdy może edytować to, co zostało
      end
    end
    helper_method :can_edit?

    # Metoda pomocnika sprawdza, czy obecny użytkownik 
    # jest administratorem
    def admin?; current_user.admin?; end
    helper_method :admin?
    
    # Wstępne filtrowanie w celu ograniczenia pewnych akcji do użycia przez administratora
    def require_admin
      unless admin?
        flash[:warning] = "Niestety, tylko administratorzy mogą to zrobić."
        redirect_to messages_url
      end
    end

    # Wstępne filtrowanie wymagające poprawności modelu obecnego użytkownika 
    # generalnie używane przy tworzeniu pierwszego użytkownika.
    def check_for_valid_user
      if logged_in? and !current_user.valid?
        flash[:warning] = "Proszę utworzyć konto administratora"
        redirect_to edit_user_url(:id => current_user)
        return false
      end
    end

end