class QuizzesController < ApplicationController
  
  before_filter :find_quiz, :except => [ :index, :create ]
  before_filter :check_permissions, 
    :only => [ :edit, :reorder, :questions, :destroy_question ]

  # Wyświetla najnowsze quizy
  def index
    @quizzes = Quiz.recent
  end
  
  # Tworzy nowy quiz i zapisuje identyfikator sesji użytkownika
  def create
    quiz = Quiz.new params[:new_quiz]
    quiz.session_id = session.session_id
    quiz.save
    redirect_to edit_quiz_url(:id => quiz)
  end
  
  # Dostarcza widok służący do edycji quizu
  def edit
  end

  # Tworzy nowe pytanie za pomocą zwykłego formularza albo przez Ajaksa
  def create_q
    @question = @quiz.questions.create params[:question]
    respond_to do |format|
      format.html { redirect_to edit_quiz_url }
      format.js
    end
  end

  # obsługuje ponowne uporządkowanie pytań przy użyciu metody przeciągnij i upuść za pomocą Ajaksa
  def reorder
    params[:quiz].each_with_index do |id, position|
      q = @quiz.questions.find id
      q.position = position + 1
      q.save
    end
    render :nothing => true
  end

  # Obsługuje usuwanie pytań za pomocą Ajaksa
  def destroy_q
    question = @quiz.questions.find params[:question_id]
    question.destroy
    render :nothing => true
  end

  # Pokazuje pięć pierwszych pytań, na które nie były podane złe odpowiedzi
  def show
    @questions = @quiz.questions.unmissed right_keys
  end
  
  # Zwraca odpowiedź do pytania za pomocą Ajaksa
  def answer
    score @quiz.id, params[:question_id], params[:right]=='true'
    last = @quiz.questions.find params[:last]
    @next = last.next right_keys
  end

  # Zeruje tablicę wyników użytkownika dla danego quizu
  def reset
    reset_scoreboard params[:id]
    redirect_to quiz_url
  end
  
  private
  
    # Filtr wstępny znajdujący quiz o danym identyfikatorze
    def find_quiz( ) @quiz = Quiz.find params[:id] end
    
    # Filtr wstępny, aby upewnić się, że tylko twórca quizu może go edytować
    def check_permissions
      redirect_to home_url and return false unless mine?
    end
    
    # Sprawdzanie, czy @quiz został utworzony przez danego użytkownika
    def mine?
      @quiz.session_id == session.session_id
    end
    helper_method :mine?

    # Opakowuje sesję, aby zapisywać wyniki quizu użytkownika
    def scoreboard id=nil
      return (session[:quizzes] ||= {}) unless id
      return (scoreboard[id.to_i] ||= {})
    end

    # Czyści tablicę wyników danego użytkownika dla danego quizu
    def reset_scoreboard id
      scoreboard[id.to_i] = {}
    end

    # Odpowiedź (+right+) na pytanie +q+ z quizu +id+
    def score id, q, right
      scoreboard(id)[q.to_i] = right
    end

    # Tablica asocjacyjna reprezentująca prawidłowe odpowiedzi dla quizu +id+
    def right(id) scoreboard(id).reject{ |q, v| !v } end
    helper_method :right

    # Tablica asocjacyjna reprezentująca błędne odpowiedzi dla quizu +id+
    def wrong(id) scoreboard(id).reject{ |q, v| v } end
    helper_method :wrong
    
    # Oddzielany przecinkami łańcuch znaków zawierający identyfikatory właściwych odpowiedzi 
    # dla bieżącego quizu.
    def right_keys
      questions = right(@quiz.id)
      questions.keys.join ','
    end

end