/*
 * Konwertujemy znak na kod szesnastkowy, dziesitny, binarny, semkowy i HTML, 
 * a nastpnie obudowujemy kade z pl kodem XML i odsyamy je klientowi w odpowiedzi. 
 */

package com.oreilly.ajax.servlet;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class AjaxResponseServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        // key to parametr przesyany przez w zmiennej JavaScript
        // o nazwie url (patrz plik index.html)
        String key = req.getParameter("key");
        StringBuffer returnXML = null; 
        if (key != null) {
            
            // pobieramy pierwszy znak z parametru key
            // jako liczb cakowit (int) i konwertujemy go na acuch String
            int keyInt = key.charAt(0);
            
            returnXML = new StringBuffer("\r\n<converted-values>");
            returnXML.append("\r\n<decimal>"+
                                Integer.toString(keyInt)+"</decimal>");
            returnXML.append("\r\n<hexadecimal>0x"+
                                Integer.toString(keyInt,16)+"</hexadecimal>");
            returnXML.append("\r\n<octal>0"+
                                Integer.toString(keyInt,8)+"</octal>");
            returnXML.append("\r\n<hyper>&amp;0x"+
                                Integer.toString(keyInt,16)+";</hyper>");
            returnXML.append("\r\n<binary>"+
                                Integer.toString(keyInt,2)+"B</binary>");
            returnXML.append("\r\n</converted-values>");
            
            // przygotowujemy odpowied
            res.setContentType("text/xml");
            res.setHeader("Cache-Control", "no-cache");
            // wysyamy acuch XML
            res.getWriter().write(returnXML.toString());
        }
        else {
            // jeli klawisz (key) powraca jako null, zwracamy znak zapytania.
            res.setContentType("text/xml");
            res.setHeader("Cache-Control", "no-cache");
            res.getWriter().write("?");
        }
    }
 
}