var tabs = new Tabs("#ccf","#fff");
var map;

// Funkcja obiektowa dla kadego
// pojedynczego elementu photo
function photo(id, url) {
   this.id = id;
   this.url = url;
   this.longitude = null;
   this.latitude = null;
   this.setLocation = function(lon,lat) {
      this.longitude = lon;
      this.latitude = lat;
   }
}

// Globalny obiekt Photo sucy do zarzdzania
// wszystkimi wywoaniami Ajaksa zwizanymi ze zdjciami 
// i przetwarzania wszelkich danych dotyczcych zdj
var Photo = {
   currentPhoto : -1,
   processPhotos : function(obj) {
      this.photos = new Array(obj.photos.photo.length);
      for (var i = 0; i < obj.photos.photo.length; i++) {
         var pic = obj.photos.photo[i];
         var url = "http://farm" + pic.farm + ".static.flickr.com/" +
            pic.server + "/" + pic.id + "_" + pic.secret + ".jpg";
         this.photos[i] = new photo(pic.id, url);
      }
      aaManageEvent(aaElem('button'),'click',aaBindEventListener(this,this.loadPhoto));
      this.getPhoto();
   },
   // Metoda obsugi zdarze pobierajca nastpne zdjcie
   loadPhoto   : function(evnt) {
      evnt = evnt ? evnt : window.event;
      aaCancelEvent(evnt);
      this.getPhoto();
      return false;
   },

   // Przetwarza danie pobrania nastpnego zdjcia i pobiera lokalizacj,
   // jeli nie jest jeszcze dostpna w obiekcie photo
   getPhoto     : function() {
       this.currentPhoto++;
       if (this.currentPhoto >= this.photos.length) this.currentPhoto = 0;
       var pic = this.photos[this.currentPhoto];
       aaElem("image").src=pic.url;
       if (!pic.latitude) {
         aaAddScript("http://api.flickr.com/services/rest/?method=flickr.photos.geo.getLocation&photo_id=" + 
              pic.id + "&api_key=98dc95d53bbd454ad501591bbc53532a&format=json&jsoncallback=Photo.placeMarker");
       } else {
         this.recenterMap();
       }
       window.location.hash = this.currentPhoto;
    },
    placeMarker  : function(obj) {
      var lat = parseFloat(obj.photo.location.latitude);
      var lon = parseFloat(obj.photo.location.longitude);
      this.photos[this.currentPhoto].setLocation(lon,lat);
      var point = new GLatLng(lat,lon);
      var marker = new GMarker(point);
      map.addOverlay(marker);
      map.setCenter(point, 13);
    },
    recenterMap  : function() {
       var pic = this.photos[this.currentPhoto];
       var point = new GLatLng(pic.latitude,pic.longitude);
       map.setCenter(point,13);
    }
};
     
// Konfiguracja zdarze load i unload
aaManageEvent(window,"load",setUp);
aaManageEvent(window,"unload",GUnload);

// Jeli przegldarka jest zgodna z map, naley utworzy map i pobra zdjcia na podstawie
// identyfikatora uytkownika; uywane s ustawienia domylne - wywoanie pobiera informacje o 100 zdjciach 
function setUp() {

  setUpTabs();

  if (GBrowserIsCompatible()) {
    map = new GMap2(aaElem("map"));
    map.addControl(new GSmallMapControl());
    map.addControl(new GMapTypeControl());
    map.setCenter(new GLatLng(38.627952, -90.1843880), 13);

    // associate map with page
    var cnt = aaElem("mapcontent");
    var mapObj = aaElem("map");
    cnt.appendChild(mapObj);
    mapObj.style.visibility="visible";

    var hash = window.location.hash;
    if (hash) {
       var subLoc = hash.split("#")[1];
       Photo.currentPhoto = parseInt(subLoc) - 1;
    }

    aaAddScript("http://api.flickr.com/services/rest/?method=flickr.photos.search&user_id=69562477@N00&api_key=98dc95d53bbd454ad501591bbc53532a&format=json&jsoncallback=Photo.processPhotos");
  }

}

