var xmlhttp;

// Uycie obsugi zdarze z biblioteki Prototype
Event.observe(window,"load",  function() {
   new Rico.Accordion( $('accordionDiv'), {panelHeight: 200} );
   setUp();
});

// Konfigurowanie sposobu wywietlania strony
function setUp() {
   var divs = document.getElementsByTagName('div');
   for (var i = 0; i < divs.length; i++) {
     if (divs[i].className == 'name') {
        var drink = new Drink(divs[i]);
        if (drink.drink.id == 'tea') drink.getRecipe();
     }
   }
   
}

// Obiekt Class biblioteki Prototype suy do 
// utworzenia obiektu Drink
Drink = Class.create();

// Metody obiektu Drink s dodawane za pomoc
// waciwoci prototype
Drink.prototype = {

   // Inicjowanie jest wywoywane automatycznie przy tworzeniu
   // obiektu za pomoc instrukcji Class.create biblioteki Prototype
   initialize: function(drink) { 
     this.drink = drink;
     this._attachBehaviors();
     this.state = 'notloaded';
   },
   _attachBehaviors: function() {
      Event.observe(this.drink,"click",this.getRecipe.bindAsEventListener(this));
   },
   getRecipe : function() {
      if (this.state=='loaded') return;
      if (!xmlhttp) xmlhttp = aaGetXmlHttpRequest();
      var drink = this.drink.id;
      var qry = "drink=" + drink;
      var url = 'recipe5.php?' + qry;
      xmlhttp.open('GET', url, true);
      xmlhttp.onreadystatechange = this.printRecipe.bindAsEventListener(this);
      xmlhttp.send(null);
   },
   printRecipe : function () {
      if(xmlhttp.readyState == 4 && xmlhttp.status == 200) {

        // Ustawienie stanu
        this.state = 'loaded';

        // Dostp do elementu recipe i wyczyszczenie go
        var recipe = document.getElementById(this.drink.id + "-area");
        recipe.innerHTML = "";

        // Dodawanie nagwka
        var title = xmlhttp.responseXML.getElementsByTagName('title')[0].firstChild.nodeValue;
        var titleNode = document.createElement('div');
        titleNode.className='title';
        titleNode.appendChild(document.createTextNode(title));
        recipe.appendChild(titleNode);

        // Dodawanie skadnikw
        var ingredients = xmlhttp.responseXML.getElementsByTagName('ingredient');
        for (var i = 0; i < ingredients.length; i++) {
           var x = document.createElement('div');
           x.className = 'ingredient';
           x.appendChild(document.createTextNode(ingredients[i].firstChild.nodeValue));
           recipe.appendChild(x);
        }

        // Dodawanie instrukcji
       var instr = xmlhttp.responseXML.getElementsByTagName('instruction')[0].firstChild.nodeValue;
       var instrNode = document.createElement('div');
       instrNode.className='instruction';
       instrNode.appendChild(document.createTextNode(instr));
       recipe.appendChild(instrNode);
      }

   }};
 
