
var cache = {
   offset : 80,
   fetch : 40
};

aaManageEvent(window,"load", function() {
  var slider = YAHOO.widget.Slider.getVertSlider("sliderbg",
         "sliderthumb", 0, 400);
  slider.setValue(0,true);
  slider.subscribe("change",adjustPage);

  // Wykrycie przegldarki Internet Explorer i uycie elementu embed
  if (document.all && !window.opera) {
    var embed = document.createElement('embed');
    embed.src = 'bubble.svg';
    embed.type = 'image/svg+xml';
    embed.width='100%';
    embed.height = '300';
    aaElem('obj').appendChild(embed);

  } else { 
    var obj= document.createElement('object');
    obj.type = 'image/svg+xml';
    obj.id = 'svgDoc';
    obj.data = 'bubble.svg';
    obj.width = '100%';
    obj.height = '300';
    aaElem('obj').appendChild(obj);
  }

  createTable();
  getRows(0);

  aaElem('inner').style.position="relative";
});

// Dostosowuje kontener na tabel na podstawie pozycji
// i okrela, czy trzeba zwikszy pami podrczn
// dla bazy danych
function adjustPage(offset) {

   var inner = aaElem('inner');
   var newTop = -offset;
   inner.style.top = newTop + "px";

   // Jeli przesunicie jest wiksze ni w pamici podrcznej,
   // naley pobra wiersze i zaktualizowa t pami
   if (offset > cache.offset) {
      getRows(cache.fetch);
      cache.offset+=80;
      cache.fetch+=40;
   }
}

// Pobiera nastpn grup wierszy
function getRows(start) {
   var url = 'getposts.php?start=' + start;
   var script = document.createElement('script');
   script.type = 'text/javascript';
   script.src = url + '&limit=40&callback=printRows';
   document.getElementsByTagName('head')[0].appendChild(script);
}

// Tworzy i docza komrk tabeli
function createTableCell(value,tr) {

   // Tworzy element <td> 
   var cell = document.createElement("td");

   // Tworzy wze tekstowy
   var text = document.createTextNode(value);

   // Docza utworzony wze tekstowy do komrki <td>
   cell.appendChild(text);

   // Docza komrk <td> do wiersza <tr>
   tr.appendChild(cell);

   return tr;
}

// Tworzy pust tabel i dodaje do strony;
// ustawia styl top kontenera
function createTable() {
   var inner = aaElem('inner');

   var table = document.createElement('table');
   table.id = 'dataTable';
   var tableBody = document.createElement("tbody");
   tableBody.id = "dataTableBody";
   table.appendChild(tableBody);
   inner.appendChild(table);
   inner.style.top = "0px";
}

// Dodaje nowo pobrane wiersze jako wiersze tabeli
function printRows(rowsObj) {

   // Usuwa stare dane
   var tableBody = aaElem('dataTableBody');

   // Wiersze tabeli
   for(var i = 0; i < rowsObj.length; i++) {
        // Tworzy element <tr>
        var row = document.createElement("tr");
        aaManageEvent(row,'mouseover',aaBindEventListener(row,showBubble));
        aaManageEvent(row,'mouseout',aaBindEventListener(row,restoreRow));
        row = createTableCell(rowsObj[i].id, row);

        // Tworzy znacznik anchor i tytu
        var cell = document.createElement("td");
        cell.innerHTML = "<a href='" + rowsObj[i].guid + "'>" + rowsObj[i].title + "</a>";
        row.appendChild(cell);

        row = createTableCell(rowsObj[i].comments,row);

       tableBody.appendChild(row);
   }
}

function showBubble(evnt) {
   var row = this;
   var val = parseInt(row.lastChild.firstChild.nodeValue);
   val = val * 5;
   row.style.backgroundColor = "#ff0000";
   
   // Pobieranie w przegldarce Internet Explorer
   if (document.all && !window.opera) {
      var svgDocument = document.embeds[0].getSVGDocument();
      var svgObject = svgDocument.getElementById('circle1');

   // Pobieranie w pozostaych przegldarkach
   } else {
      var svgDocument = document.getElementById("svgDoc").contentDocument;
      var svgObject = svgDocument.getElementById('circle1');
   }

   // Ustawianie we wszystkich przegldarkach
   svgObject.setAttribute("r",val);
}

function restoreRow(evnt) {
   var row = this;
   row.style.backgroundColor="#ccc";
}
