// przechowuje obiekt XMLHttpRequest
var xmlHttp = createXmlHttpRequestObject();
// przechowuje adres i parametry zdalnego serwera
var serverAddress = "friendly.php?action=GetNews";
// zmienne określające częstotliwość łączenia z serwerem
var updateInterval = 5; // ile sekund oczekiwać na pobranie nowej wiadomości
var errorRetryInterval = 30; // ile sekund czekać po wystąpieniu błędu serwera
// parametr true pozwala wyświetlić szczegóły błędu
var debugMode = true;
 
// tworzy obiekt XMLHttpRequest
function createXmlHttpRequestObject() 
{
  // przechowa odwołanie do obiektu XMLHttpRequest
  var xmlHttp;
  // powinno działać dla wszystkich przeglądarek z wyjątkiem IE6 i starszych
  try
  {
    // próbuje stworzyć obiekt XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // zakładając, że IE6 lub starsza
    var XmlHttpVersions = new Array("MSXML2.XMLHTTP.6.0",
      "MSXML2.XMLHTTP.5.0",
      "MSXML2.XMLHTTP.4.0",
      "MSXML2.XMLHTTP.3.0",
      "MSXML2.XMLHTTP",
      "Microsoft.XMLHTTP");
    // sprawdza każdy prog id aż któryś zadziała
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
      { 
        // próbuje stworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {}
    }
  }
  // zwraca stworzony obiekt albo wyświetla komunikat o błędzie
  if (!xmlHttp)
    alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}

// funkcja wyświetla nową wiadomość na stronie
function display($message)
{
  // pobiera odwołanie do elementu <div> na stronie
  myDiv = document.getElementById("myDivElement");
  // wyświetla komunikat
  myDiv.innerHTML = $message + "<br/>";
}

// funkcja wyświetlająca komunikat o błędzie
function displayError($message)
{
  // wyświetla szczegóły techniczne błędu jeśli debugMode ma wartość true
  display("Błąd podczas otrzymywania wiadomości! Spróbuję za " +
    errorRetryInterval + " sekund." + (debugMode ? "<br/>" + $message : ""));
  // ponawia sekwencję
  setTimeout("process();", errorRetryInterval * 1000);
}

// asynchroniczne wywołanie serwera
function process()
{
  // kontynuuje, jeśli xmlHttp nie jest pusty
  if (xmlHttp)
  {
    // próbuje połączyć się z serwerem
    try
    {
      // usuń tę linię jeśli nie podoba Ci się komunikat 'Pobieranie...'
      display("Pobieranie nowej wiadomości z serwera...")
      // asynchroniczne żądanie HTTP otrzymania nowej wiadomości
      xmlHttp.open("GET", serverAddress, true);
      xmlHttp.onreadystatechange = handleGettingNews;
      xmlHttp.send(null);
    }
    catch(e)
    {
      displayError(e.toString());
    }
  }
}

// funkcja wywoływana przy zmianie statusu żądania HTTP
function handleGettingNews() 
{
  // kiedy readyState ma wartość 4, jesteśmy gotowi do odebrania odpowiedzi z Sewera
  if (xmlHttp.readyState == 4) 
  {
    // kontynuuje tylko, gdy status HTTP ma wartość "OK"
    if (xmlHttp.status == 200) 
    {
      try
      {
        // przetwarza wiadomość z serwera
        getNews();
      }
      catch(e)
      {
        // komunikat o błędzie
        displayError(e.toString());
      }
    } 
    else
    {
      // komunikat o błędzie
      displayError(xmlHttp.statusText);   
    }
  }
}

// obsługuje odpowiedź otrzymaną z serwera
function getNews()
{
  // pobiera odpowiedź serwera
  var response = xmlHttp.responseText;
  // błąd serwera?
  if (response.indexOf("ERRNO") >= 0 || response.indexOf("error") >= 0
    || response.length == 0)
    throw(response.length == 0 ? "Błąd serwera." : response);
  // wyświetla wiadomość
  display(response);
  // ponawia sekwencję
  setTimeout("process();", updateInterval * 1000);
}

