// przechowuje obiekt XMLHttpRequest
var xmlHttp = createXmlHttpRequestObject();

// tworzy obiekt XMLHttpRequest
function createXmlHttpRequestObject() 
{
  // przechowa odwołanie do obiektu XMLHttpRequest
  var xmlHttp;
  // powinno działać dla wszystkich przeglądarek z wyjątkiem IE6 i starszych
  try
  {
    // próbuje utworzyć obiekt XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // w przypadku, gdy przeglądarką jest IE6 lub starsz
    var XmlHttpVersions = new Array("MSXML2.XMLHTTP.6.0",
      "MSXML2.XMLHTTP.5.0",
      "MSXML2.XMLHTTP.4.0",
      "MSXML2.XMLHTTP.3.0",
      "MSXML2.XMLHTTP",
      "Microsoft.XMLHTTP");
    // sprawdza każdy identyfikator programu, aż jeden zadziała
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
      { 
        // próbuje utworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {}
    }
  }
  // zwraca utworzony obiekt lub wyświetla komunikat o błędzie
  if (!xmlHttp)
    alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}


// wywołana do odczytania pliku z serwera
function process()
{
  // kontynuuje tylko jeśli obiekt xmlHttp istnieje
  if (xmlHttp)
  {
    // próbuje połączyć się z serwerem
    try
    {
      // inicjalizacja odczytu pliku async.txt z serwera
      xmlHttp.open("GET", "async.txt", true);
      xmlHttp.onreadystatechange = handleRequestStateChange;
      xmlHttp.send(null);
    }
    // w przypadku niepowodzenia wyświetla komunikat o błędzie
    catch (e)
 
    {
      alert("Nie mogę połączyć się z serwerem:\n" + e.toString());
    }
  }
}

// funkcja obsługująca odpowiedź http
function handleRequestStateChange() 
{
  // pobranie odwołania do elementu <div> na stronie
  myDiv = document.getElementById("myDivElement");
  // wyświetla status żądania
  if (xmlHttp.readyState == 1)
  {
    myDiv.innerHTML += "Status żądania: 1 (ładuje) <br/>";
  }
  else if (xmlHttp.readyState == 2)
  {
    myDiv.innerHTML += "Status żądania: 2 (załadowany) <br/>";
  }
  else if (xmlHttp.readyState == 3)
  {
    myDiv.innerHTML += "Status żądania: 3 (interaktywny) <br/>";
  }
  // kiedy status readyState wynosi 4, odczytujemy odpowiedź serwera
  else if (xmlHttp.readyState == 4) 
  {
    // kontynuuje tylko, gdy status serwera ma wartość "OK"
    if (xmlHttp.status == 200) 
    {
      try
      {
        // czyta wiadomość wysłaną z serwera
        response = xmlHttp.responseText;
        // wyświetla wiadomość
        myDiv.innerHTML += 
          "Status żądania: 4 (zakończony). Serwer odpowiedział: <br/>";
        myDiv.innerHTML += response;
      }
      catch(e)
      {
        // wyświetla komunikat o błędzie
        alert("Błąd podczas odczytu odpowiedzi: " + e.toString());
      }
    } 
    else
    {
      // wyświetla status wiadomości
      alert("Pojawił się problem w uzyskaniu danych:\n" +
        xmlHttp.statusText);
    }
  }
}

