// przechowuje instancję obiektu XMLHttpRequest
var xmlHttp = createXmlHttpRequestObject();
// parametr ustawiony na true pozwala wyświetlić szczegółowy komunikat o błędzie
var showErrors = true;
// tworzy instancję obiektu XMLHttpRequest
function createXmlHttpRequestObject() 
{
  // przechowa odwołanie do obiektu XMLHttpRequest
  var xmlHttp;
  // powinno zadziałać dla wszystkich przeglądarek z wyjątkiem IE6 i starszych
  try
  {
    // próbuje tworzyć obiekt  XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // zakładając, że IE6 lub starsza
    var XmlHttpVersions = new Array("MSXML2.XMLHTTP.6.0",
                                    "MSXML2.XMLHTTP.5.0",
                                    "MSXML2.XMLHTTP.4.0",
                                    "MSXML2.XMLHTTP.3.0",
                                    "MSXML2.XMLHTTP",
                                    "Microsoft.XMLHTTP");
    // sprawdza każdy  prog id aż któryś zadziała
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
      { 
        // próbuje utworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {} // ignoruje potencjalne błędy
    }
  }
  // zwraca utworzony obiekt lub wyświetla komunikat o błędzie
  if (!xmlHttp)
      alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}
// funkcja, która wyświetla komunikat o błędzie
function displayError($message)
{
  // ignoruje błędy,  jeśli parametr  showErrors ma wartość false
  if (showErrors)
  {
    // wyłącza wyświetlanie błędów
    showErrors = false;
    // wyświetla komunikat o błędzie
    alert("Wystąpił błąd: \n" + $message);
  }
}
// pobiera tytuły wątków i wyświetla je
function getFeed(feedLink, feed)
{
  // kontynuuje tylko, jeśli xmlHttp nie jest pusty
  if (xmlHttp)
  {
    // próbuje połączyć się z serwerem
    try
    {
      if (xmlHttp.readyState == 4 || xmlHttp.readyState == 0)
      {
        /* Pobiera liczbę wątków i przegląda je w pętli, aby zmienić nazwę klasy ich kontenera <li>. */
        var numberOfFeeds = document.getElementById("feedList").childNodes.length;
        for (i = 0; i < numberOfFeeds; i++)
          document.getElementById("feedList").childNodes[i].className = "";
        // zmienia nazwę klasy klikniętego wątku, aby został podświetlony
        feedLink.className = "active";
        // wyświetla komunikat "Ładuję..." podczas uruchamiania wątku
        document.getElementById("loading").style.display = "block";
        // wywołuje stronę na serwerze, aby wykonać operacje po stronie serwera
        params = "feed=" + feed;
        xmlHttp.open("POST", "rss_reader.php", true);
        xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xmlHttp.onreadystatechange = handleHttpGetFeeds;
        xmlHttp.send(params);
      }
      else
      {
        // jeśli połączenie jest zajęte, ponawia próbę po 1 sekundzie
        setTimeout("getFeed('" + feedLink + "', '" + feed + "');", 1000);
      }
    }
    // wyświetla błąd, jeśli operacja nie powiodła się
    catch (e)
    {
      displayError(e.toString());
    }
  }
}
// funkcja która pobiera odpowiedź HTTP
function handleHttpGetFeeds() 
{
  // kontynuuje, jeśli proces został zakończony
  if (xmlHttp.readyState == 4) 
  {
   // kontynuuje jedynie, jeśli status HTTP ma wartość "OK"
    if (xmlHttp.status == 200) 
    {
      try
      {
        displayFeed();
      }
      catch(e)
      {
        // wyświetla komunikat o błędzie
        displayError(e.toString());
      }
    } 
    else 
    {
      displayError(xmlHttp.statusText);
    }
  }
}
// przetwarza odpowiedź serwera
function displayFeed()
{
  // pobiera odpowiedź serwera w postaci tekstu i sprawdza, czy nie ma błędów
  var response = xmlHttp.responseText;
  // błąd serwera?
  if (response.indexOf("ERRNO") >= 0
    || response.indexOf("error:") >= 0
    || response.length == 0)
    throw(response.length == 0 ? "Pusta odpowiedź serwera." : response);
  // ukrywa komunikat "Ładuję..." 
  document.getElementById("loading").style.display = "none";
  //łączy przetransformowaną w XSL strukturę XML z istniejącą już strukturą DOM
  var titlesContainer = document.getElementById("feedContainer");
  titlesContainer.innerHTML = response;
  //uwidacznia kontener wątku
  document.getElementById("feedContainer").style.display = "block";
  // czyści tekst strony startowej
  document.getElementById("home").innerHTML = "";
}

