// przechowanie odwołania  do obiektu XMLHttpRequest
var xmlHttp = null; 

// tworzy wzór XMLHttpRequest
function createXmlHttpRequestObject() 
{
  // przechowuje odwołanie do  obiektu XMLHttpRequest
  var xmlHttp;
  // zapewnia działanie we wszystkich przeglądarkach z wyjątkiem IE6 i starszych
  try
  {
    // próbuje stworzyć obiekt XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // zakładając, że przeglądarką jest IE6 lub starsza
    var XmlHttpVersions = new Array("MSXML2.XMLHTTP.6.0",
                                    "MSXML2.XMLHTTP.5.0",
                                    "MSXML2.XMLHTTP.4.0",
                                    "MSXML2.XMLHTTP.3.0",
                                    "MSXML2.XMLHTTP",
                                    "Microsoft.XMLHTTP");
    // sprawdza kolejne identyfikatory programów (prog id), dopóki któryś  nie zadziała
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
      { 
        // próbuje stworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {}
    }
  }
  // zwraca utworzony obiekt lub wyświetla komunikat o błędzie
  if (!xmlHttp)
    alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}

// inicjuje żądanie AJAX
function ajaxRequest(url, callback)
{
  // przechowuje odwołanie do funkcji, która zostanie wywołana w przypadku otrzymania odpowiedzi z serwera
  var innerCallback = callback;
  // tworzy obiekt XMLHttpRequest przy pierwszym wywołaniu metody
  if (!xmlHttp) xmlHttp = createXmlHttpRequestObject();
  // gdy połączenie jest wolne, inicjalizuje nowe żądanie do serwera
  if (xmlHttp && (xmlHttp.readyState == 4 || xmlHttp.readyState == 0)) 
 
  {
    xmlHttp.onreadystatechange = handleGettingResults;
    xmlHttp.open("GET", url, true);
    xmlHttp.send(null);
  }
  else
    // gdy jest realizowane jakieś inne połączenie, ponawia próbę po 1 sekundzie
    setTimeout("ajaxRequest(url,callback)", 1000);
  
  // ta funkcja jest wywoływana przy zmianie stanu żądania
  function handleGettingResults() 
  {
    // przechodzi dalej jedynie, gdy transakcja na serwerze została zakończona
    if (xmlHttp.readyState == 4) 
    {
      // status HTTP o wartości 200 oznacza, że transakcja zakończyła się z powodzeniem
      if (xmlHttp.status == 200) 
      {
      // wykonuje funkcję zwrotną, przekazując odpowiedź serwera
        innerCallback(xmlHttp.responseText)
      } 
      else
      {
      // wyświetla komunikat o błędzie
        alert("Nie można uzyskać połączenia z serwerem");
      }
    }
  }
}

