<?php
// ładuje obsługę błędów i konfigurację bazy
require_once ('error_handler.php'); 
require_once ('config.php');
// klasa wspierająca weryfikację formularza
class Validate
{
  // przechowuje połączenie z bazą
  private $mMysqli;
  // konstruktor otwiera połączenie z bazą
  function __construct()
  {
    $this->mMysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_DATABASE);
  }
  // destruktor zamyka połączenie z bazą
  function __destruct()
  {
    $this->mMysqli->close();      
  }
    
  // wspiera weryfikację AJAX, sprawdza pojedynczą wartość
  public function ValidateAJAX($inputValue, $fieldID)
  {
    // sprawdza, które pole jest weryfikowanej wykonuje sprawdzenie wartości
    switch($fieldID)
    {
      // sprawdza poprawność nazwy użytkownika
      case 'txtUsername':
        return $this->validateUserName($inputValue);
        break;  
      // sprawdza poprawność imienia
      case 'txtName':
        return $this->validateName($inputValue);
        break;        
      // sprawdza, czy została wybrana płeć
      case 'selGender':
        return $this->validateGender($inputValue);
        break;         
      // sprawdza poprawność dnia
      case 'txtBthDay':
        return $this->validateBirthDay($inputValue);
        break;       
      // sprawdza poprawność miesiąca
      case 'selBthMonth':
        return $this->validateBirthMonth($inputValue);
        break;        
      // sprawdza poprawność roku
      case 'txtBthYear':
        return $this->validateBirthYear($inputValue);
        break;        
      // sprawdza poprawność adresu email
      case 'txtEmail':
        return $this->validateEmail($inputValue);
        break;        
      // sprawdza poprawność numeru telefonu
      case 'txtPhone':
        return $this->validatePhone($inputValue);
        break;      
      // sprawdza zaznaczenie pola "Przeczytałem warunki użytkowania"
      case 'chkReadTerms':
        return $this->validateReadTerms($inputValue);
        break;
    }
  }
  // sprawdza, czy wypełnione są wszystkie pola
  public function ValidatePHP()
  {
    // flaga błędu zostaje ustawiona na 1, jeśli wystąpi błąd
    $errorsExist = 0;
    // czyści flagi błędów w sesji
    if (isset($_SESSION['errors']))
      unset($_SESSION['errors']);
    // domyślnie wartości pól są uznane za poprawne
    $_SESSION['errors']['txtUsername'] = 'hidden';
    $_SESSION['errors']['txtName'] = 'hidden';
    $_SESSION['errors']['selGender'] = 'hidden';
    $_SESSION['errors']['selBthMonth'] = 'hidden';
    $_SESSION['errors']['txtBthDay'] = 'hidden';
    $_SESSION['errors']['txtBthYear'] = 'hidden';
    $_SESSION['errors']['txtEmail'] = 'hidden';
    $_SESSION['errors']['txtPhone'] = 'hidden';
    $_SESSION['errors']['chkReadTerms'] = 'hidden';  
    // weryfikuje nazwę użytkownika
    if (!$this->validateUserName($_POST['txtUsername']))
    {
      $_SESSION['errors']['txtUsername'] = 'error';
      $errorsExist = 1;
    }    
    // weryfikuje imię
    if (!$this->validateName($_POST['txtName']))
    {
      $_SESSION['errors']['txtName'] = 'error';
      $errorsExist = 1;
    }  
    // weryfikuje płeć
    if (!$this->validateGender($_POST['selGender']))
    {
      $_SESSION['errors']['selGender'] = 'error';
      $errorsExist = 1;
    }    
     // weryfikuje dzień urodzenia
    if (!$this->validateBirthDay($_POST['txtBthDay']))
    {
      $_SESSION['errors']['txtBthDay'] = 'error';
      $errorsExist = 1;
    }    
    // weryfikuje miesiąc urodzenia
    if (!$this->validateBirthMonth($_POST['selBthMonth']))
    {
      $_SESSION['errors']['selBthMonth'] = 'error';
      $errorsExist = 1;
    }
    // weryfikuje rok urodzenia i całą datę
    if (!$this->validateBirthYear($_POST['selBthMonth'] . '#' . $_POST['txtBthDay'] .
      '#' . $_POST['txtBthYear']))
    {
      $_SESSION['errors']['txtBthYear'] = 'error';
      $errorsExist = 1;
    }    
    // weryfikuje email
    if (!$this->validateEmail($_POST['txtEmail']))
    {
      $_SESSION['errors']['txtEmail'] = 'error';
      $errorsExist = 1;
    }  
    // weryfikuje numer telefonu
    if (!$this->validatePhone($_POST['txtPhone']))
    {
      $_SESSION['errors']['txtPhone'] = 'error';
      $errorsExist = 1;
    }    
    // weryfikuje, czy pole "warunki użytkowania" jest zaznaczone
    if (!isset($_POST['chkReadTerms']) || 
        !$this->validateReadTerms($_POST['chkReadTerms']))
    {
      $_SESSION['errors']['chkReadTerms'] = 'error';
      $_SESSION['values']['chkReadTerms'] = '';
      $errorsExist = 1;
    }
    // jeśli nie znaleziono błędów, to ustawia wartość pomyślnej weryfikacji
    if ($errorsExist == 0)
    {
      return 'allok.php';
    }
    else
    {
      // jeśli są błędy, zapisuje wprowadzone dane
      foreach ($_POST as $key => $value)
      {
        $_SESSION['values'][$key] = $_POST[$key];
      }
      return 'index.php';
    }
  }
  // weryfikacja nazwy użytkownika, nie może być pusta lub już rejestrowana
  private function validateUserName($value)
  {
    // przycięcie spacji początkowych i końcowych oraz zmiana znaków na kod
    $value = $this->mMysqli->real_escape_string(trim($value));
    // pusta nazwa użytkownika nie jest poprawna
    if ($value == null) 
      return 0; // niepoprawna nazwa
    // sprawdza czy użytkownik nie występuje już w bazie
    $query = $this->mMysqli->query('SELECT user_name FROM users ' .
      'WHERE user_name="' . $value . '"');
    if ($this->mMysqli->affected_rows > 0)
      return '0'; // niepoprawna nazwa
    else
      return '1'; // poprawna nazwa
  }
  // weryfikacja imienia
 private function validateName($value)
  {
    // przycięcie spacji początkowych i końcowych oraz zmiana znaków na kod
    $value = trim($value);
    // puste pole nie jest poprawne
    if ($value) 
      return 1; // poprawne
    else
      return 0; // niepoprawne
  }
  // weryfikacja płci
  private function validateGender($value)
  {
    // użytkownik musi określić płeć
    return ($value == '0') ? 0 : 1;
  }
  // weryfikacja miesiąca
  private function validateBirthMonth($value)
  {
    // miesiąc musi być niezerowy i z przedziału od 1 do 12
    return ($value == '' || $value > 12 || $value < 1) ? 0 : 1;
  }  
  // weryfikacja dnia
  private function validateBirthDay($value)
  {
    // dzień musi być z przedziału 1 do 31 i nie może być wartością pustą
    return ($value == '' || $value > 31 || $value < 1) ? 0 : 1;
  }  
  // weryfikacja roku i całej daty
  private function validateBirthYear($value)
  {
    // poprawny rok to wartość z pomiędzy 1900 a 2000
    // pobiera całą datę (mm#dd#yyyy)
    $date = explode('#', $value);
    // data jest niepoprawna jeśli brakuje dnia, miesiąca lub roku
    if (!$date[0]) return 0;
    if (!$date[1] || !is_numeric($date[1])) return 0;
    if (!$date[2] || !is_numeric($date[2])) return 0;
    // sprawdza datę
    return (checkdate($date[0], $date[1], $date[2])) ? 1 : 0;
  }
  // weryfikuje email
  private function validateEmail($value)
  {
    // poprawne formaty email: *@*.*, *@*.*.*, *.*@*.*, *.*@*.*.*)
    return (!eregi('^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$', $value)) ? 0 : 1;
  }  
  // weryfikuje numer telefonu
  private function validatePhone($value)
  {
    // poprawny format numeru: ##-##-###-##-##
    return (!eregi('^[0-9]{2}-*[0-9]{2}-*[0-9]{3}-*[0-9]{2}-*[0-9]{2}$', $value)) ?
      0 : 1;
  }
  // czy użytkownik zaznaczył checkbox
  private function validateReadTerms($value)
  {
    // poprawna wartość to 'true'
    return ($value == 'true' || $value == 'on') ? 1 : 0;
  }
}
?>
