<?php
// ładuje sekwencję obsługi błędów
require_once ('error_handler.php');
// ładuje konfigurację
require_once ('config.php');

// klasa przechowuje funkcjonalności aplikacji WWW Friendly
class Friendly
{
  // przechowuje połączenie z baza danych
  private $mMysqli;

  // konstruktor otwiera bazę danych
  function __construct()
  {
    $this->mMysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_DATABASE);
  }

  // generuje nową wiadomość
  public function getNews()
  {
    // przechowa nowe linie
    $news = 'Żadnych wiadomości na dziś';
    // SQL wybierający losowo dwóch użytkowników z bazy
    $query = 'SELECT user_name FROM users ' .
             'ORDER BY RAND() ' .
             'LIMIT 2';
    // wykonuje zapytanie
    $result = $this->mMysqli->query($query);  
    // przechowuje wiersze użytkowników
    $row1 = $result->fetch_array(MYSQLI_ASSOC);
    $row2 = $result->fetch_array(MYSQLI_ASSOC);
    // zamyka strumień wejściowy
    $result->close();  
    // generuje wiadomości
    if (!$row1 || !$row2)
    {
      $news = 'Projekt potrzebuje więcej użytkowników!';
    }
    else
    {
 
      // tworzy wiadomość HTML
      $name1 = '<b>' . $row1['user_name'] . '</b>';
      $name2 = '<b>' . $row2['user_name'] . '</b>';
      $randNum = $this->getRandomNumber();
      $news = 'Użytkownik ' . $name1 . ' pracuje z użytkownikiem ' . $name2 .
              ' nad projektem nr ' . $randNum . '.';
    }
    // wyświetla linie komunikatu
    return $news;
  }
  
  // zwraca losową liczbę z przedziału od 1 do 100
  private function getRandomNumber()
  {
    // opóźnia wykonanie o ćwierć sekundy
    usleep(250000);
    // przechowuje adresy i parametry zdalnych serwerów
    $serverAddress = 'http://www.random.org/cgi-bin/randnum';
    $serverParams = 'num=1&min=1&max=100';
    // uzyskuje liczbę losową ze zdalnego serwera
    $randomNumber = file_get_contents($serverAddress . '?' .  $serverParams);
    // wyświetla liczbę losową
    return trim($randomNumber);
  }

  // destruktor zamyka połączenie z bazą
  function __destruct()
  {
    $this->mMysqli->close();      
  }
}
?>
