<?php
// ładuje moduł obsługi błędów
require_once('error_handler.php');
// ładuje plik konfoguracyjny
require_once('config.php');
// klasa, której zadaniem jest obsługa funkcji podpowiadania i autouzupełniania po stronie serwera
class Suggest
{
  // obsługa bazy danych
  private $mMysqli;
  // konstruktor, otwiera połączenie z bazą
  function __construct() 
  {   
    // łączy z bazą
    $this->mMysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_DATABASE);
  }
  // destruktor, zamyka połączenie z bazą
  function __destruct() 
  {
    $this->mMysqli->close();
  }
  // zwraca nazwy wszystkich funkcji, które zaczynają się od wartości $keyword
  public function getSuggestions($keyword)
  {
    // obcina łańcuch słowa kluczowego
    $patterns = array('/\s+/', '/"+/', '/%+/');
    $replace = array('');
    $keyword = preg_replace($patterns, $replace, $keyword);
    // tworzy zapytanie SQL, które pobiera pasujące nazwy funkcji z bazy
    if($keyword != '')
      $query = 'SELECT name ' . 'FROM suggest ' .  'WHERE name LIKE "' .
        $keyword . '%"';
    // jeśli słowo kluczowe nie zostało podane, nie zwraca nic
    else
      $query = 'SELECT name ' . 'FROM suggest ' . 'WHERE name=""'; 
    // wykonuje zapytanie SQL
    $result = $this->mMysqli->query($query);
    // tworzy odpowiedź w formacie XML
    $output = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
    $output .= '<response>';    
    // jeśli są wyniki, przegląda je w pętli i dodaje do danych wyjściowych
    if($result->num_rows)
      while ($row = $result->fetch_array(MYSQLI_ASSOC))
        $output .= '<name>' . $row['name'] . '</name>';
    // zamyka strumień wyjściowy 
    $result->close();
    // dodaje znacznik kończący plik
    $output .= '</response>';   
    // zwraca wyniki
    return $output;  
  }
//koniec klasy Suggest
}
?>