<?php
// uruchamia plik konfiguracyjny
require_once('config.php');
// uruchamia obsługę błędów
require_once('error_handler.php');
// klasa zawierająca funkcjonalności strony serwera
class Chat
{
  // obsługuje bazę danych
  private $mMysqli;  
  // konstruktor otwiera połączenie z bazą danych
  function __construct() 
  {   
    // łączy się z bazą
    $this->mMysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_DATABASE); 
  }
  // destruktor zamyka połączenie z bazą
  public function __destruct() 
  {
    $this->mMysqli->close();
  }
  // kasuje zawartość tabeli zawierającej wiadomości
  public function deleteMessages()
  { 
    // tworzy zapytanie SQL, które dodaje nową wiadomość do serwera
    $query = 'TRUNCATE TABLE chat'; 
    // wykonuje zapytanie SQL
    $result = $this->mMysqli->query($query);      
  } 
  /*
   Metoda postMessages dodaje nową wiadomość do bazy
   - $name odpowiada nazwie użytkownika wysłanej wiadomości
   - $messsage to wysłana wiadomość
   - $color zawiera parametry koloru wybranego przez użytkownika
  */ 
  public function postMessage($name, $message, $color)
  {  
    // usuwa znaki specjalne przez dodaniem wiadomości do bazy
    $name = $this->mMysqli->real_escape_string($name);
    $message = $this->mMysqli->real_escape_string($message);
    $color = $this->mMysqli->real_escape_string($color);
    // tworzy zapytanie SQL, które dodaje nową wiadomość do serwera
    $query = 'INSERT INTO chat(posted_on, user_name, message, color) ' .
      'VALUES (NOW(), "' . $name . '" , "' . $message . '","' . $color . '")'; 
    // wykonuje zapytanie SQL
    $result = $this->mMysqli->query($query);      
  }
  /*
   Metoda retrieveMessages pobiera wiadomości, które zostały wysłane na serwer
   - parametr $id jest wysyłany przez klienta i odpowiada identyfikatorowi ostatniej wiadomości pobranej przez niego.
       Wiadomości o późniejszych id będą pobrane z serwera i wysłane klientowi w formacie XML
  */
  public function retrieveNewMessages($id=0) 
  {
    // usuwa znaki specjalne przez dodaniem wiadomości do bazy
    $id = $this->mMysqli->real_escape_string($id);
    // tworzy zapytanie SQL, które pobiera wiadomość do serwera
    if($id>0)
    {
      // pobiera wiadomości świeższe niż te o danym $id
      $query = 'SELECT chat_id, user_name, message, color, ' .
        'DATE_FORMAT(posted_on, "%Y-%m-%d %H:%i:%s") ' . 'AS posted_on ' .
          'FROM chat WHERE chat_id > ' . $id . ' ORDER BY chat_id ASC'; 
    }
    else
    {
      // przy pierwszym uruchomieniu wyświetla ostatnich 50 wiadomości z serwera
      $query = 
      'SELECT chat_id, user_name, message, color, posted_on FROM ' .
        '(SELECT chat_id, user_name, message, color, ' .
        'DATE_FORMAT(posted_on, "%Y-%m-%d %H:%i:%s") AS posted_on ' . 'FROM chat ' .
        'ORDER BY chat_id DESC ' . 'LIMIT 50) AS Last50 ' . 'ORDER BY chat_id ASC';
    } 
    // wykonuje zapytanie
    $result = $this->mMysqli->query($query);  
    // tworzy odpowiedź XML
    $response = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
    $response .= '<response>';  
    // wysyła czystą flagę
    $response .= $this->isDatabaseCleared($id);
    // sprawdza czy jest odpowiedź
    if($result->num_rows)
    {      
       // przegląda w pętli wszystkie przechwycone wiadomości, aby stworzyć wiadomość wynikową
        while ($row = $result->fetch_array(MYSQLI_ASSOC))
        {
              $id = $row['chat_id'];
              $color = htmlspecialchars ($row['color']);
              $userName = htmlspecialchars ($row['user_name']);
              $time = htmlspecialchars ($row['posted_on']); 
              $message = htmlspecialchars ($row['message']);
              $response .= '<id>' . $id . '</id>' . 
              '<color><![CDATA[' . $color . ']]></color>' . 
              '<time>' . $time . '</time>' .
              '<name><![CDATA[' . $userName . ']]></name>' .
              '<message><![CDATA[' . $message . ']]></message>';
        } 
      // zamyka połączenie z bazą, jak szybko jest to możliwe
      $result->close();
    }
    // kończy odpowiedź XML i wysyła ją
    $response = $response . '</response>';
    return $response;    
  }
  /*
   Metoda isDatabaseCleared sprawdza, czy baza została wyczyszczona od ostatniego wywołania serwera
        -   parametr $id zawiera identyfikator ostatniej wiadomości pobranej rpzez klienta
  */
  private function isDatabaseCleared($id)
  {
    if($id>0)
    {
      //sprawdzenie liczby wierszy o id mniejszym niż uzyskany od klienta  mówi nam, czy baza była ostatnio czyszczona 
      $check_clear = 'SELECT count(*) old FROM chat where chat_id<=' . $id;
      $result = $this->mMysqli->query($check_clear);
      $row = $result->fetch_array(MYSQLI_ASSOC);      
            
      // jeśli baza była czyszczona, tablica musi być przeładowana
      if($row['old']==0)
        return '<clear>true</clear>';     
    }
    return '<clear>false</clear>';
  }
}
?>
