<?php
   require_once('connect.php');
   require_once('tasks.php');
   if (!dbConnect()) {
      echo 'Nie udało się nawiązać połączenia z bazą danych.';
      exit;
   }
   $tasks = getTasks();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "DTD/xhtml1-strict.dtd">
<html>
   <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
      <title>Lista sortowana oparta na Ajaksie oraz PHP</title>
      <link rel="stylesheet" type="text/css" href="sortable.css" /> 
      <script type="text/javascript" src="scriptaculous-js-1.7.0/lib/prototype.js"></script>
      <script type="text/javascript" src="scriptaculous-js-1.7.0/src/scriptaculous.js"></script>
      <script type="text/javascript" src="tasks.js"></script>
   </head>
   <body onload="delTask()">
      <h1>Lista sortowana</h1>
      <div id="newList">
         <ul id="task_list" class="sortable">
            <?php foreach ($tasks as $task_id => $task) { ?>
            <li id="task_<?= $task_id ?>"><?= $task ?></li>
            <?php } ?>
         </ul>
      </div>
      <hr />
      <h3>Dodawanie nowego zadania</h3>
      <form>
         <input type="text" name="newTask" id="newTask" size="50" maxlength="100" />
         <input type="button" name="addTask" id="addTask" value="Dodaj zadanie" onclick="appendTask()"/>
      </form>
      <br /><br />
      <hr />
      <div id="dropZone"><strong>
         Zadania do usunięcia należy upuścić tutaj
      </strong></div>
      
      <script type="text/javascript">
         var id = 0;
         function delTask () {
            Droppables.add ('dropZone', {onDrop: function (element) {
               var myDelete = confirm("Czy chcesz usunąć to zadanie?");
               if (myDelete) {
                  Element.hide(element);
                  removeTask(element.id);
               }
            }
            });
         }

         function updateList()
         {
            new Ajax.Request('order.php', {method : 'post', parameters : Sortable.serialize('task_list')});
         }
         Sortable.create('task_list', { tag: "li", onUpdate : updateList });
      </script>
   </body>
</html>