from datetime import datetime
from airflow.decorators import dag, task
from airflow.operators.python import PythonOperator

def show_fake_person():
    from faker import Faker
    fake = Faker("pl_PL")
    print("Imię i nazwisko:", fake.name())
    print("Adres:", fake.address())
    print("Adres e-mail:", fake.email())
    print("Numer telefonu:", fake.phone_number())
    print("Data urodzenia:", fake.date_of_birth())

@dag("queue_and_pool_example_tf", start_date=datetime(2025, 2, 1), schedule="0 7 * * *",
     tags=["r10", "taskflow"])
def queue_and_pool_example_tf():
    @task(queue="default", pool="single_pool", task_id="default_small")
    def show_fake_person():
        from faker import Faker
        fake = Faker("pl_PL")
        print("Imię i nazwisko:", fake.name())
        print("Adres:", fake.address())
        print("Adres e-mail:", fake.email())
        print("Numer telefonu:", fake.phone_number())
        print("Data urodzenia:", fake.date_of_birth())
        
    t_default_small = show_fake_person()
    t_default_small
    
    t_processing_pool = show_fake_person.override(queue="processing",
                                                  pool="processing_pool",
                                                  task_id="processing")()
    t_processing_pool

queue_and_pool_example_tf()