from airflow.decorators import dag, task
from airflow.datasets import Dataset
from datetime import datetime

avg_order_path = "/airflow-sandbox/datasets/avg_order_data.csv"
avg_order_dataset = Dataset(avg_order_path)

@dag(dag_id="trigger_by_dataset_tf", start_date=datetime(2025, 1, 1), schedule=avg_order_dataset, tags=["r8", "taskflow"])
def trigger_by_dataset_tf():
    
    @task.bash
    def echo_ds():
        return "echo '{{ ds }}'"
    
    t_echo_ds = echo_ds()

trigger_by_dataset_tf()