from airflow import DAG
from airflow.operators.bash import BashOperator
from airflow.datasets import Dataset
from datetime import datetime

avg_order_path = "/airflow-sandbox/datasets/avg_order_data.csv"
avg_order_dataset = Dataset(avg_order_path)

with DAG(dag_id="trigger_by_dataset", start_date=datetime(2025, 1, 1), schedule=avg_order_dataset, tags=["r8", "with"]):
    t_echo_ds = BashOperator(
        task_id="echo_ds",
        bash_command="echo '{{ ds }}'"
    )
    
    t_echo_ds