from airflow import DAG
from airflow.providers.common.sql.operators.sql import SQLExecuteQueryOperator
    
with DAG(dag_id="sql_example", start_date=None, schedule=None, tags=["r6", "with"]):
    t_sql_query = SQLExecuteQueryOperator(
        task_id="sql_query",
        conn_id="example_db_postgres",
        sql="SELECT first_name, last_name FROM customers LIMIT 1"
    )
    
    t_sql_script = SQLExecuteQueryOperator(
        task_id="sql_script",
        conn_id="example_db_postgres",
        sql="sql/top_client.sql"
    )
    
    t_sql_query_params = SQLExecuteQueryOperator(
        task_id="sql_query_params",
        conn_id="example_db_postgres",
        sql="SELECT first_name, last_name FROM customers WHERE first_name = %(arg)s",
        parameters={"arg": "Anna"}
    )
    
    t_sql_script_params = SQLExecuteQueryOperator(
        task_id="sql_script_params",
        conn_id="example_db_postgres",
        sql="sql/between_salary.sql",
        parameters={
            "min_val": 200,
            "max_val": 300
        }
    )
    
t_sql_query >> t_sql_query_params
t_sql_script >> t_sql_script_params


