from airflow import DAG
from airflow.providers.common.sql.operators.sql import SQLCheckOperator, SQLValueCheckOperator
    
with DAG(dag_id="check_and_value", start_date=None, schedule=None, tags=["r6", "with"]):
    t_check_example = SQLCheckOperator(
        task_id="check_example",
        conn_id="example_db_postgres",
        sql="SELECT 1 FROM inventory"
    )
    
    t_value_three = SQLValueCheckOperator(
        task_id="value_three",
        conn_id="example_db_postgres",
        sql="SELECT count(*) FROM orders WHERE total_amount > 299",
        pass_value=3
    )
    
    t_check_count = SQLValueCheckOperator(
        task_id="check_count",
        conn_id="example_db_postgres",
        sql="SELECT count(*) FROM orders  WHERE status = 'delivered'",
        pass_value=6,
        tolerance=0.20
    )
    
    t_bool_sql = SQLCheckOperator(
        task_id="bool_example",
        conn_id="example_db_postgres",
        sql="SELECT min(min_stock_level) >= 10 FROM inventory"
    )
    

t_check_example >> t_value_three >> t_check_count >> t_bool_sql
