from airflow import DAG
from airflow.operators.empty import EmptyOperator
from airflow.providers.http.operators.http import HttpOperator
from airflow.providers.http.sensors.http import HttpSensor
from datetime import timedelta

with DAG(dag_id="http_sensor", start_date=None, schedule=None,
         tags=["r4", "with"]):
    t_start = EmptyOperator(task_id="start")
    
    t_get_request = HttpOperator(
        task_id="get_requests",
        http_conn_id="http_json_placeholder",
        method="GET",
        endpoint="todos/1"
    )
    
    t_check_api = HttpSensor(
        task_id="check_api",
        mode="poke",
        poke_interval=timedelta(seconds=15),
        timeout=timedelta(minutes=2),
        http_conn_id="http_json_placeholder",
        endpoint="todos/1",
        request_params={},
        response_check=lambda response: response.status_code == 200
    )
    
    
t_start >> t_check_api >> t_get_request