from airflow import DAG
from airflow.operators.python import PythonOperator
from airflow.providers.postgres.hooks.postgres import PostgresHook

def export_data_to_csv(tbl_name):
    hook = PostgresHook(postgres_conn_id="example_db_postgres")
    hook.bulk_dump(tbl_name, f"/tmp/{tbl_name}.csv")

with DAG(dag_id="postgres_hook", start_date=None, schedule=None, tags=["r7", "with"]):
    t_export_data = PythonOperator(
        task_id="export_data",
        python_callable=export_data_to_csv,
        op_args=["customers"]
    )
    
t_export_data