from airflow import DAG
from airflow.operators.empty import EmptyOperator
from airflow.operators.python import BranchPythonOperator


def choice_tasks():
    from random import randint
    value = randint(1,9)
    print(value)
    
    if 1 <= value <= 3:
        return "low_value"
    elif 4 <= value <= 6:
        return ["low_value", "high_value"]
    else:
        return "high_value"

with DAG(dag_id="branch_example", start_date=None, schedule=None,
         tags=["r4", "with"]):
    t_choice = BranchPythonOperator(
        task_id="choice_tasks",
        python_callable=choice_tasks
    )
    
    t_low = EmptyOperator(task_id="low_value")
    t_high = EmptyOperator(task_id="high_value")
    t_end = EmptyOperator(task_id="end")
    
t_choice >> [t_low, t_high] >> t_end

