from airflow import DAG
from airflow.operators.python import PythonOperator, ExternalPythonOperator

def day_number(number):
    match number:
        case 1:
            return "Poniedziałek"
        case 2:
            return "Wtorek"
        case 3:
            return "Środa"
        case 4:
            return "Czwartek"
        case 5:
            return "Piątek"
        case 6 | 7:
            return "Weekend"
        case _:
            return "Błędna wartość"
  

with DAG(dag_id="python_external", start_date=None, schedule=None,
         tags=["r2", "with"]):
    t_python = PythonOperator(
        task_id="python_example",
        python_callable=day_number,
        op_args=[2]
    )
    
    t_external = ExternalPythonOperator(
        task_id="external_example",
        python_callable=day_number,
        op_args=[1],
        python="/root/.pyenv/versions/3.9.21/bin/python"
    )
    
t_python >> t_external